/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.library.constant;

import com.mojang.blaze3d.platform.Window;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.common.packet.AoAPackets;
import net.tslat.aoa3.common.packet.packets.ScreenEffectPacket;
import net.tslat.aoa3.util.ColourUtil;
import net.tslat.smartbrainlib.util.RandomUtil;

public class ScreenImageEffect {
    private final Type type;
    private boolean fullscreen = false;
    private float scale = 1.0f;
    private ColourUtil.Colour colour = new ColourUtil.Colour(1.0f, 1.0f, 1.0f, 1.0f);
    private int duration = 60;
    private long expiredAt = 0L;
    private float posX;
    private float posY;
    private ResourceLocation cachedTexture = null;

    public ScreenImageEffect(Type type) {
        this.type = type;
    }

    public ScreenImageEffect scaled(float scale) {
        this.scale = scale;
        return this;
    }

    public ScreenImageEffect randomScale() {
        return this.scaled((float)RandomUtil.randomValueBetween((double)0.25, (double)1.25));
    }

    public ScreenImageEffect coloured(int red, int green, int blue, int alpha) {
        this.colour = new ColourUtil.Colour((float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f, (float)alpha / 255.0f);
        return this;
    }

    public ScreenImageEffect coloured(int colour) {
        this.colour = new ColourUtil.Colour(colour);
        return this;
    }

    public ScreenImageEffect duration(int ticks) {
        this.duration = ticks;
        return this;
    }

    public ScreenImageEffect fullscreen(boolean fullscreen) {
        this.fullscreen = fullscreen;
        return this;
    }

    public float getScale() {
        return this.scale;
    }

    public int getColour() {
        return this.colour.packed();
    }

    public float getRed() {
        return this.colour.red();
    }

    public float getGreen() {
        return this.colour.green();
    }

    public float getBlue() {
        return this.colour.blue();
    }

    public float getAlpha() {
        return this.colour.alpha();
    }

    public int getDuration() {
        return this.duration;
    }

    public Type getType() {
        return this.type;
    }

    public ResourceLocation getTexture() {
        return this.cachedTexture;
    }

    public boolean isFullscreen() {
        return this.fullscreen;
    }

    public void sendToPlayer(ServerPlayer player) {
        AoAPackets.messagePlayer(player, new ScreenEffectPacket(this));
    }

    public void init(Window window, long gameTime) {
        if (this.expiredAt != 0L) {
            return;
        }
        this.setExpiry(gameTime);
        ThreadLocalRandom random = ThreadLocalRandom.current();
        if (this.type.variants == 1) {
            this.cachedTexture = this.type.texture;
        } else {
            ResourceLocation baseTexture = this.type.texture;
            this.cachedTexture = new ResourceLocation(baseTexture.m_135827_(), baseTexture.m_135815_().replace(".png", 1 + ((Random)random).nextInt(this.type.variants) + ".png"));
        }
        if (!this.fullscreen) {
            this.posX = random.nextFloat(window.m_85445_() - 127) / this.scale;
            this.posY = random.nextFloat(window.m_85446_() - 127) / this.scale;
        }
    }

    public void setExpiry(long gameTime) {
        this.expiredAt = gameTime + (long)this.duration;
    }

    public boolean isExpired(long gameTime) {
        return this.expiredAt <= gameTime;
    }

    public long getExpiry() {
        return this.expiredAt;
    }

    public float x() {
        return this.posX;
    }

    public float y() {
        return this.posY;
    }

    public static enum Type {
        SCRATCH(AdventOfAscension.id("textures/gui/overlay/effect/scratch.png"), 4),
        BLOOD(AdventOfAscension.id("textures/gui/overlay/effect/splat.png"), 4),
        ACTION_KEY_VIGNETTE(AdventOfAscension.id("textures/gui/overlay/misc/action_key_activation_vignette.png"), 1);

        public final ResourceLocation texture;
        public final int variants;

        private Type(ResourceLocation texture, int variants) {
            this.texture = texture;
            this.variants = variants;
        }
    }
}

