/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.library.constant;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.CombatEntry;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.PlayerUtil;

public enum BossDropsScheme {
    ON_GROUND(BossDropsScheme::onGroundDistributor),
    LAST_PLAYER_TO_HIT(BossDropsScheme::lastPlayerToHitDistributor),
    MOST_DAMAGING_PLAYER(BossDropsScheme::mostDamagingPlayerDistributor),
    SPLIT_BETWEEN_PLAYERS(BossDropsScheme::splitBetweenPlayersDistributor);

    private final Consumer<LivingDropsEvent> dropsEventConsumer;

    private BossDropsScheme(Consumer<LivingDropsEvent> dropsEventConsumer) {
        this.dropsEventConsumer = dropsEventConsumer;
    }

    public void handleDrops(LivingDropsEvent event) {
        this.dropsEventConsumer.accept(event);
    }

    private static void onGroundDistributor(LivingDropsEvent ev) {
    }

    private static void lastPlayerToHitDistributor(LivingDropsEvent ev) {
        Player attacker;
        List combatEntries = ev.getEntity().m_21231_().f_19276_;
        if (combatEntries.isEmpty() && (attacker = PlayerUtil.getPlayerOrOwnerIfApplicable(ev.getSource().m_7639_())) instanceof Player) {
            Player player = attacker;
            BossDropsScheme.giveDropsToPlayer(player, ev.getDrops().iterator());
            return;
        }
        for (int i = combatEntries.size() - 1; i >= 0; --i) {
            Entity attacker2 = ((CombatEntry)combatEntries.get(i)).m_19263_().m_7639_();
            if (!(attacker2 instanceof Player)) continue;
            Player player = (Player)attacker2;
            BossDropsScheme.giveDropsToPlayer(player, ev.getDrops().iterator());
            return;
        }
    }

    private static void mostDamagingPlayerDistributor(LivingDropsEvent ev) {
        LivingEntity killer = ev.getEntity().m_21231_().m_19294_();
        if (killer == null) {
            killer = PlayerUtil.getPlayerOrOwnerIfApplicable(ev.getSource().m_7639_());
        }
        if (killer instanceof Player) {
            Player player = (Player)killer;
            BossDropsScheme.giveDropsToPlayer(player, ev.getDrops().iterator());
        }
    }

    private static void splitBetweenPlayersDistributor(LivingDropsEvent ev) {
        ObjectOpenHashSet players = new ObjectOpenHashSet();
        for (Entity attacker : EntityUtil.getAttackersForMob(ev.getEntity(), null)) {
            Player pl = PlayerUtil.getPlayerOrOwnerIfApplicable(attacker);
            if (pl == null) continue;
            players.add(pl);
        }
        if (players.size() == 0) {
            ev.setCanceled(true);
            return;
        }
        if (players.size() == 1) {
            BossDropsScheme.giveDropsToPlayer((Player)players.iterator().next(), ev.getDrops().iterator());
            return;
        }
        ObjectArrayList drops = new ObjectArrayList(ev.getDrops().size());
        int totalItems = 0;
        for (ItemEntity entity : ev.getDrops()) {
            if (entity.m_32055_().m_41619_()) continue;
            drops.add(entity.m_32055_());
        }
        Collections.shuffle(drops);
        ev.getDrops().clear();
        for (ItemStack stack : drops) {
            totalItems += stack.m_41613_();
        }
        Object2IntOpenHashMap messages = new Object2IntOpenHashMap();
        int perPlayerDrops = Math.max(1, totalItems / players.size());
        int playerDropCount = 0;
        ThreadLocalRandom random = ThreadLocalRandom.current();
        while (!drops.isEmpty() && !players.isEmpty()) {
            int dropIndex = ((Random)random).nextInt(drops.size());
            ItemStack drop = (ItemStack)drops.get(dropIndex);
            Player player = (Player)players.iterator().next();
            int amount = 1 + ((Random)random).nextInt(Math.min(drop.m_41613_(), perPlayerDrops - playerDropCount));
            playerDropCount += amount;
            Component displayName = drop.m_41786_();
            if (amount == drop.m_41613_()) {
                if (!player.m_150109_().m_36054_(drop)) {
                    players.remove(player);
                    playerDropCount = 0;
                    for (Object2IntMap.Entry entry : messages.object2IntEntrySet()) {
                        player.m_213846_((Component)LocaleUtil.getLocaleMessage("message.feedback.nowhere.boss.drops", ChatFormatting.GREEN, new Component[]{Component.m_237113_((String)String.valueOf(entry.getIntValue())), (Component)entry.getKey()}));
                    }
                    continue;
                }
                messages.compute((Object)displayName, (name, count) -> count != null ? count + amount : amount);
                drops.remove(dropIndex);
            } else {
                ItemStack newStack = drop.m_41777_();
                drop.m_41764_(drop.m_41613_() - amount);
                newStack.m_41764_(amount);
                if (!player.m_150109_().m_36054_(newStack)) {
                    players.remove(player);
                    playerDropCount = 0;
                    for (Object2IntMap.Entry entry : messages.object2IntEntrySet()) {
                        player.m_213846_((Component)LocaleUtil.getLocaleMessage("message.feedback.nowhere.boss.drops", ChatFormatting.GREEN, new Component[]{Component.m_237113_((String)String.valueOf(entry.getIntValue())), (Component)entry.getKey()}));
                    }
                    continue;
                }
                messages.compute((Object)displayName, (name, count) -> count != null ? count + amount : amount);
            }
            if (playerDropCount < perPlayerDrops) continue;
            players.remove(player);
            playerDropCount = 0;
        }
        if (!players.isEmpty()) {
            Player player = (Player)players.iterator().next();
            for (Object2IntMap.Entry entry : messages.object2IntEntrySet()) {
                player.m_213846_((Component)LocaleUtil.getLocaleMessage("message.feedback.nowhere.boss.drops", ChatFormatting.GREEN, new Component[]{Component.m_237113_((String)String.valueOf(entry.getIntValue())), (Component)entry.getKey()}));
            }
        }
        LivingEntity entity = ev.getEntity();
        for (ItemStack stack : drops) {
            ev.getDrops().add(new ItemEntity(entity.m_9236_(), entity.m_20185_(), entity.m_20186_() + 0.5, entity.m_20189_(), stack));
        }
    }

    private static void giveDropsToPlayer(Player player, Iterator<ItemEntity> iterator) {
        Object2IntOpenHashMap messages = new Object2IntOpenHashMap();
        while (iterator.hasNext()) {
            ItemStack item = iterator.next().m_32055_();
            int amount = item.m_41613_();
            Component displayName = item.m_41786_();
            if (!player.m_150109_().m_36054_(item)) break;
            messages.compute((Object)displayName, (name, count) -> count != null ? count + amount : amount);
            iterator.remove();
        }
        for (Object2IntMap.Entry entry : messages.object2IntEntrySet()) {
            player.m_213846_((Component)LocaleUtil.getLocaleMessage("message.feedback.nowhere.boss.drops", ChatFormatting.GREEN, new Component[]{Component.m_237113_((String)String.valueOf(entry.getIntValue())), (Component)entry.getKey()}));
        }
    }
}

