/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.library.builder;

import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.registries.ForgeRegistries;
import net.tslat.aoa3.client.ClientOperations;
import net.tslat.aoa3.util.ColourUtil;
import net.tslat.aoa3.util.RegistryUtil;
import net.tslat.smartbrainlib.util.RandomUtil;

public final class ParticleBuilder {
    private final ParticleOptions particle;
    private final Supplier<Vec3> posGenerator;
    private boolean isSimple = true;
    private Consumer<?> particleConsumer = null;
    private double cutoffDistance = 32.0;
    private boolean force = false;
    private boolean ambient = false;
    private int countPerPosition = 1;
    private int count = 1;
    private Vec3 velocity = Vec3.f_82478_;
    private ColourUtil.Colour colourOverride = null;
    private int lifespan = 0;
    private float gravity = Float.MAX_VALUE;
    private float inertia = 0.0f;
    private float scale = 1.0f;

    private ParticleBuilder(ParticleOptions particle, Supplier<Vec3> posGenerator) {
        this.particle = particle;
        this.posGenerator = posGenerator;
    }

    public static ParticleBuilder forPos(ParticleOptions particle, Supplier<Vec3> positionGenerator) {
        return new ParticleBuilder(particle, positionGenerator);
    }

    public static ParticleBuilder forPos(ParticleOptions particle, double x, double y, double z) {
        return new ParticleBuilder(particle, () -> new Vec3(x, y, z));
    }

    public static ParticleBuilder forPos(ParticleOptions particle, Vec3 pos) {
        return ParticleBuilder.forPos(particle, pos.f_82479_, pos.f_82480_, pos.f_82481_);
    }

    public static ParticleBuilder forRandomPosInBounds(ParticleOptions particle, AABB bounds) {
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        return new ParticleBuilder(particle, () -> new Vec3((double)rand.nextFloat((float)bounds.f_82288_, (float)bounds.f_82291_), (double)rand.nextFloat((float)bounds.f_82289_, (float)bounds.f_82292_), (double)rand.nextFloat((float)bounds.f_82290_, (float)bounds.f_82293_)));
    }

    public static ParticleBuilder forRandomPosInEntity(ParticleOptions particle, Entity entity) {
        if (!entity.isMultipartEntity()) {
            return ParticleBuilder.forRandomPosInBounds(particle, entity.m_20191_());
        }
        PartEntity[] parts = entity.getParts();
        return ParticleBuilder.forPos(particle, () -> {
            AABB bounds = RandomUtil.oneInNChance((int)(parts.length + 1)) ? entity.m_20191_() : ((PartEntity)RandomUtil.getRandomSelection((Object[])parts)).m_20191_();
            return new Vec3(RandomUtil.randomValueBetween((double)((float)bounds.f_82288_), (double)((float)bounds.f_82291_)), RandomUtil.randomValueBetween((double)((float)bounds.f_82289_), (double)((float)bounds.f_82292_)), RandomUtil.randomValueBetween((double)((float)bounds.f_82290_), (double)((float)bounds.f_82293_)));
        });
    }

    public ParticleBuilder spawnNTimes(int amount) {
        this.count = amount;
        return this;
    }

    public ParticleBuilder particlesPerPosition(int amount) {
        this.countPerPosition = amount;
        this.isSimple = false;
        return this;
    }

    public ParticleBuilder velocity(Vec3 velocity) {
        this.velocity = velocity;
        this.isSimple = false;
        return this;
    }

    public ParticleBuilder velocity(double x, double y, double z) {
        return this.velocity(new Vec3(x, y, z));
    }

    public ParticleBuilder ignoreDistanceAndLimits() {
        this.force = true;
        this.isSimple = false;
        return this;
    }

    public ParticleBuilder cutoffDistance(double distance) {
        this.cutoffDistance = distance;
        this.isSimple = false;
        return this;
    }

    public ParticleBuilder isAmbient() {
        this.ambient = true;
        this.isSimple = false;
        return this;
    }

    public ParticleBuilder colourOverride(float red, float green, float blue, float alpha) {
        this.colourOverride = new ColourUtil.Colour(red, green, blue, alpha);
        this.isSimple = false;
        return this;
    }

    public ParticleBuilder colourOverride(int red, int green, int blue, int alpha) {
        return this.colourOverride((float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f, (float)alpha / 255.0f);
    }

    public ParticleBuilder lifespan(int ticks) {
        this.lifespan = ticks;
        this.isSimple = false;
        return this;
    }

    public ParticleBuilder gravityOverride(float gravity) {
        this.gravity = gravity;
        this.isSimple = false;
        return this;
    }

    public ParticleBuilder inertiaOverride(float inertia) {
        this.inertia = inertia;
        this.isSimple = false;
        return this;
    }

    public ParticleBuilder scaleMod(float modifier) {
        this.scale = modifier;
        this.isSimple = false;
        return this;
    }

    public ParticleBuilder particleConsumer(Consumer<?> consumer) {
        this.particleConsumer = consumer;
        this.isSimple = false;
        return this;
    }

    public ParticleOptions getParticle() {
        return this.particle;
    }

    public Supplier<Vec3> getPositionGenerator() {
        return this.posGenerator;
    }

    public int getCountPerPosition() {
        return this.countPerPosition;
    }

    public int getCount() {
        return this.count;
    }

    public Vec3 getVelocity() {
        return this.velocity;
    }

    public double getCutoffDistance() {
        return this.cutoffDistance;
    }

    public boolean getShouldForce() {
        return this.force;
    }

    public boolean getIsAmbient() {
        return this.ambient;
    }

    @Nullable
    public ColourUtil.Colour getColourOverride() {
        return this.colourOverride;
    }

    public int getLifespan() {
        return this.lifespan;
    }

    public float getGravity() {
        return this.gravity;
    }

    public float getInertia() {
        return this.inertia;
    }

    public float getScaleMod() {
        return this.scale;
    }

    public void spawnParticles() {
        if (this.particle != null) {
            ClientOperations.addParticle(this, this.particleConsumer);
        }
    }

    public void toNetwork(FriendlyByteBuf buffer) {
        buffer.m_130085_(RegistryUtil.getId(this.particle.m_6012_()));
        this.particle.m_7711_(buffer);
        buffer.m_130130_(this.count);
        for (int i = 0; i < this.count; ++i) {
            Vec3 pos = this.posGenerator.get();
            buffer.writeDouble(pos.f_82479_);
            buffer.writeDouble(pos.f_82480_);
            buffer.writeDouble(pos.f_82481_);
        }
        buffer.writeBoolean(this.isSimple);
        if (this.isSimple) {
            return;
        }
        buffer.m_130130_(this.countPerPosition);
        buffer.writeDouble(this.velocity.f_82479_);
        buffer.writeDouble(this.velocity.f_82480_);
        buffer.writeDouble(this.velocity.f_82481_);
        buffer.writeDouble(this.cutoffDistance);
        buffer.writeBoolean(this.force);
        buffer.writeBoolean(this.ambient);
        buffer.writeBoolean(this.colourOverride != null);
        if (this.colourOverride != null) {
            this.colourOverride.toNetwork(buffer);
        }
        buffer.m_130130_(this.lifespan);
        buffer.writeFloat(this.gravity);
        buffer.writeFloat(this.inertia);
        buffer.writeFloat(this.scale);
    }

    public static ParticleBuilder fromNetwork(FriendlyByteBuf buffer) {
        ParticleType particleType = (ParticleType)ForgeRegistries.PARTICLE_TYPES.getValue(buffer.m_130281_());
        if (particleType == null) {
            return new ParticleBuilder(null, null);
        }
        Object particle = ParticleBuilder.deserializeParticle(buffer, particleType);
        int positionCount = buffer.m_130242_();
        final Vec3[] positions = new Vec3[positionCount];
        for (int i = 0; i < positionCount; ++i) {
            positions[i] = new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
        }
        ParticleBuilder builder = new ParticleBuilder((ParticleOptions)particle, new Supplier<Vec3>(){
            private final Vec3[] spawnPositions;
            private int index;
            {
                this.spawnPositions = positions;
                this.index = 0;
            }

            @Override
            public Vec3 get() {
                return this.spawnPositions[this.index++];
            }
        });
        builder.count = positionCount;
        if (buffer.readBoolean()) {
            return builder;
        }
        builder.countPerPosition = buffer.m_130242_();
        builder.velocity = new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
        builder.cutoffDistance = buffer.readDouble();
        builder.force = buffer.readBoolean();
        builder.ambient = buffer.readBoolean();
        if (buffer.readBoolean()) {
            builder.colourOverride = ColourUtil.Colour.fromNetwork(buffer);
        }
        builder.lifespan = buffer.m_130242_();
        builder.gravity = buffer.readFloat();
        builder.inertia = buffer.readFloat();
        builder.scale = buffer.readFloat();
        return builder;
    }

    private static <T extends ParticleOptions> T deserializeParticle(FriendlyByteBuf buffer, ParticleType<T> particleType) {
        return (T)particleType.m_123743_().m_6507_(particleType, buffer);
    }
}

