/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.library.builder;

import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import net.tslat.aoa3.library.builder.CompoundNBTBuilder;
import net.tslat.aoa3.util.RegistryUtil;

public final class ItemStackBuilder {
    private final Item item;
    private int count = 1;
    private int damage = 0;
    private CompoundTag nbt = null;

    public ItemStackBuilder(Supplier<? extends ItemLike> item) {
        this(item.get());
    }

    public ItemStackBuilder(ItemLike item) {
        this.item = item.m_5456_();
    }

    public ItemStackBuilder(ResourceLocation itemId) {
        this.item = (Item)ForgeRegistries.ITEMS.getValue(itemId);
    }

    public ItemStackBuilder count(int count) {
        this.count = count;
        return this;
    }

    public ItemStackBuilder damage(int damage) {
        if (!this.item.m_41465_()) {
            throw new IllegalArgumentException("Can't set damage for undamageable item " + RegistryUtil.getId(this.item));
        }
        this.damage = damage;
        return this;
    }

    public ItemStackBuilder withRandomDamage() {
        return this.damage(ThreadLocalRandom.current().nextInt(0, this.item.m_41462_()));
    }

    public ItemStackBuilder usesRemaining(int uses) {
        return this.damage(this.item.m_41462_() - uses);
    }

    public ItemStackBuilder nbt(CompoundTag nbt) {
        this.nbt = nbt;
        return this;
    }

    public ItemStackBuilder nbt(CompoundNBTBuilder nbtBuilder) {
        return this.nbt(nbtBuilder.build());
    }

    public ItemStack build() {
        ItemStack stack = new ItemStack((ItemLike)this.item, this.count);
        if (this.damage > 0) {
            stack.m_41721_(this.damage);
        }
        if (this.nbt != null) {
            CompoundTag tag = this.nbt;
            if (stack.m_41782_()) {
                tag = stack.m_41783_();
                for (String key : this.nbt.m_128431_()) {
                    tag.m_128365_(key, this.nbt.m_128423_(key));
                }
            }
            stack.m_41751_(tag);
        }
        return stack;
    }
}

