/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.integration.jei.recipe.whitewashing;

import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.library.util.RecipeUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.content.recipe.WhitewashingRecipe;
import net.tslat.aoa3.util.LocaleUtil;

public class WhitewashingRecipeCategory
implements IRecipeCategory<WhitewashingRecipe> {
    public static final RecipeType<WhitewashingRecipe> RECIPE_TYPE = RecipeType.create((String)"aoa3", (String)"whitewashing", WhitewashingRecipe.class);
    public static final ResourceLocation ID = new ResourceLocation("aoa3", "whitewashing");
    private final Component title = LocaleUtil.getLocaleMessage("recipe.aoa3.whitewashing");
    private final IDrawable background;
    private final IDrawable icon;

    public WhitewashingRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation texture = new ResourceLocation("aoa3", "textures/gui/containers/basic_block.png");
        this.background = guiHelper.createDrawable(texture, 26, 22, 125, 18);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)AoABlocks.WHITEWASHING_TABLE.get()));
    }

    public RecipeType<WhitewashingRecipe> getRecipeType() {
        return RECIPE_TYPE;
    }

    public Component getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, WhitewashingRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 1).addIngredients((Ingredient)recipe.m_7527_().get(0));
        builder.addSlot(RecipeIngredientRole.INPUT, 50, 1).addIngredients((Ingredient)recipe.m_7527_().get(1));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 108, 1).addItemStack(RecipeUtil.getResultItem((Recipe)recipe));
    }
}

