/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.integration.jei.recipe.infusion;

import com.mojang.blaze3d.vertex.PoseStack;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.library.util.RecipeUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.common.registration.custom.AoASkills;
import net.tslat.aoa3.content.recipe.InfusionRecipe;
import net.tslat.aoa3.player.ClientPlayerDataManager;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.util.LocaleUtil;

public class InfusionRecipeCategory
implements IRecipeCategory<InfusionRecipe> {
    public static final RecipeType<InfusionRecipe> RECIPE_TYPE = RecipeType.create((String)"aoa3", (String)"infusion", InfusionRecipe.class);
    public static final ResourceLocation ID = new ResourceLocation("aoa3", "infusion");
    private final Component title = LocaleUtil.getLocaleMessage("recipe.aoa3.infusion");
    private final IDrawable background;
    private final IDrawable icon;

    public InfusionRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation texture = new ResourceLocation("aoa3", "textures/gui/containers/infusion_table.png");
        this.background = guiHelper.createDrawable(texture, 10, 10, 156, 66);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)AoABlocks.INFUSION_TABLE.get()));
    }

    public RecipeType<InfusionRecipe> getRecipeType() {
        return RECIPE_TYPE;
    }

    public Component getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, InfusionRecipe recipe, IFocusGroup focuses) {
        NonNullList<Ingredient> ingredients = recipe.m_7527_();
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 128, 25).addItemStack(RecipeUtil.getResultItem((Recipe)recipe))).addTooltipCallback((recipeSlotView, tooltip) -> {
            ResourceLocation recipeId = recipe.m_6423_();
            if (recipeId == null) {
                return;
            }
            if (!recipeId.m_135827_().equals("aoa3")) {
                tooltip.add(LocaleUtil.getLocaleMessage("jei.tooltip.recipe.by", ChatFormatting.GRAY, new Component[]{Component.m_237113_((String)recipeId.m_135827_())}));
            }
            if (Minecraft.m_91087_().f_91066_.f_92125_ || Screen.m_96638_()) {
                tooltip.add(LocaleUtil.getLocaleMessage("jei.tooltip.recipe.id", ChatFormatting.DARK_GRAY, new Component[]{Component.m_237113_((String)recipeId.toString())}));
            }
        });
        builder.addSlot(RecipeIngredientRole.INPUT, 7, 25).addIngredients(recipe.getRecipeInput());
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                IRecipeSlotBuilder slotBuilder = builder.addSlot(RecipeIngredientRole.INPUT, 35 + x * 18, 7 + y * 18);
                if (x + y * 3 >= ingredients.size()) continue;
                slotBuilder.addIngredients((Ingredient)ingredients.get(x + y * 3));
            }
        }
        builder.setShapeless();
    }

    public void draw(InfusionRecipe recipe, IRecipeSlotsView recipeSlotsView, PoseStack matrix, double mouseX, double mouseY) {
        int posY;
        int posX;
        int width;
        int shadowColour;
        int textColour;
        String message;
        if (recipe == null) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (recipe.getInfusionReq() > 1) {
            message = ((AoASkill)AoASkills.IMBUING.get()).getName().m_130946_(": " + recipe.getInfusionReq()).getString();
            textColour = ClientPlayerDataManager.get().getSkill((AoASkill)AoASkills.IMBUING.get()).getLevel(true) < recipe.getInfusionReq() ? -40864 : -8323296;
            shadowColour = 0xFF000000 | (textColour & 0xFCFCFC) >> 2;
            width = mc.f_91062_.m_92895_(message);
            posX = 150 - width;
            posY = 10;
            mc.f_91062_.m_92883_(matrix, message, (float)(posX + 1), (float)posY, shadowColour);
            mc.f_91062_.m_92883_(matrix, message, (float)posX, (float)(posY + 1), shadowColour);
            mc.f_91062_.m_92883_(matrix, message, (float)(posX + 1), (float)(posY + 1), shadowColour);
            mc.f_91062_.m_92883_(matrix, message, (float)posX, (float)posY, textColour);
        }
        if (recipe.getMaxXp() > 0) {
            message = LocaleUtil.getLocaleString("gui.misc.skills.xp", String.valueOf(recipe.getMinXp() == recipe.getMaxXp() ? Integer.valueOf(recipe.getMaxXp()) : recipe.getMinXp() + "-" + recipe.getMaxXp()));
            textColour = -7368817;
            shadowColour = 0xFF000000 | (textColour & 0xFCFCFC) >> 2;
            width = mc.f_91062_.m_92895_(message);
            posX = 150 - width;
            posY = 50;
            mc.f_91062_.m_92883_(matrix, message, (float)(posX + 1), (float)posY, shadowColour);
            mc.f_91062_.m_92883_(matrix, message, (float)posX, (float)(posY + 1), shadowColour);
            mc.f_91062_.m_92883_(matrix, message, (float)(posX + 1), (float)(posY + 1), shadowColour);
            mc.f_91062_.m_92883_(matrix, message, (float)posX, (float)posY, textColour);
        }
    }
}

