/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.event.custom;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.tslat.aoa3.content.entity.misc.HaulingFishingBobberEntity;
import net.tslat.aoa3.event.custom.events.HaulingItemFishedEvent;
import net.tslat.aoa3.event.custom.events.HaulingRodPullEntityEvent;
import net.tslat.aoa3.event.custom.events.ItemCraftingEvent;
import net.tslat.aoa3.event.custom.events.ItemSmeltingEvent;
import net.tslat.aoa3.event.custom.events.MagicTeleportEvent;
import net.tslat.aoa3.event.custom.events.PlayerChangeXpEvent;
import net.tslat.aoa3.event.custom.events.PlayerLevelChangeEvent;
import net.tslat.aoa3.player.ServerPlayerDataManager;
import net.tslat.aoa3.player.skill.AoASkill;

public final class AoAEvents {
    public static void playerLevelChange(ServerPlayerDataManager playerDataManager, AoASkill.Instance skill, int oldLevel, boolean wasNaturallyChanged) {
        MinecraftForge.EVENT_BUS.post((Event)new PlayerLevelChangeEvent(playerDataManager, skill, oldLevel, wasNaturallyChanged));
    }

    public static float playerChangeXp(ServerPlayerDataManager playerDataManager, AoASkill.Instance skill, float xpGained, float xpAfterModifiers, boolean wasNaturallyGained) {
        PlayerChangeXpEvent event = new PlayerChangeXpEvent(playerDataManager, skill, xpGained, xpAfterModifiers, wasNaturallyGained);
        boolean cancelled = MinecraftForge.EVENT_BUS.post((Event)event);
        return cancelled ? 0.0f : event.getNewXpGain();
    }

    public static HaulingItemFishedEvent haulingItemFished(Entity hookedEntity, ItemStack rodStack, List<ItemStack> lootList, int baseXp, int rodDamage, HaulingFishingBobberEntity bobber) {
        HaulingItemFishedEvent event = new HaulingItemFishedEvent(hookedEntity, rodStack, lootList, baseXp, rodDamage, bobber);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event;
    }

    public static HaulingRodPullEntityEvent haulingRodPullEntity(Player player, ItemStack haulingRod, HaulingFishingBobberEntity bobber, Entity hookedEntity, int rodDamage, float pullStrength) {
        HaulingRodPullEntityEvent event = new HaulingRodPullEntityEvent(player, haulingRod, bobber, hookedEntity, rodDamage, pullStrength);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event;
    }

    public static boolean firePlayerCraftingEvent(Player player, ItemStack crafting, CraftingContainer craftingInventory, ResultContainer outputInventory) {
        return MinecraftForge.EVENT_BUS.post((Event)new ItemCraftingEvent(player, crafting, craftingInventory, outputInventory));
    }

    public static boolean firePlayerSmeltingEvent(Player player, ItemStack smelting, Container outputInventory) {
        return MinecraftForge.EVENT_BUS.post((Event)new ItemSmeltingEvent(player, smelting, outputInventory));
    }

    public static MagicTeleportEvent magicalTeleport(Entity entity, @Nullable Entity teleportSource, @Nullable Entity indirectTeleportSource, Vec3 teleportPosition) {
        MagicTeleportEvent event = new MagicTeleportEvent(entity, teleportSource, indirectTeleportSource, teleportPosition);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event;
    }
}

