/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.event;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.tslat.aoa3.common.particletype.CustomisableParticleType;
import net.tslat.aoa3.common.registration.AoAConfigs;
import net.tslat.aoa3.common.registration.AoAParticleTypes;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.common.registration.worldgen.AoADimensions;
import net.tslat.aoa3.scheduling.AoAScheduler;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.WorldUtil;
import net.tslat.smartbrainlib.util.RandomUtil;

public final class EntityEvents {
    public static void preInit() {
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        forgeBus.addListener(EventPriority.NORMAL, false, LivingEvent.LivingTickEvent.class, EntityEvents::onEntityUpdate);
        forgeBus.addListener(EventPriority.NORMAL, false, EntityJoinLevelEvent.class, EntityEvents::onEntityJoinWorld);
        forgeBus.addListener(EventPriority.LOWEST, false, MobSpawnEvent.FinalizeSpawn.class, EntityEvents::onEntitySpawn);
        forgeBus.addListener(EventPriority.NORMAL, false, ExplosionEvent.Detonate.class, EntityEvents::onEntityExploded);
        forgeBus.addListener(EventPriority.NORMAL, false, PlayerInteractEvent.EntityInteractSpecific.class, EntityEvents::onEntityInteract);
    }

    private static void onEntityInteract(PlayerInteractEvent.EntityInteractSpecific ev) {
        ItemStack stack;
        Piglin piglin;
        Entity entity;
        if (!ev.getEntity().f_19853_.f_46443_ && (entity = ev.getTarget()) instanceof Piglin && (piglin = (Piglin)entity).m_6844_(EquipmentSlot.HEAD).m_41720_() == Items.f_42476_ && ((stack = ev.getEntity().m_21120_(ev.getHand())).m_41720_() == Items.f_42437_ || stack.m_41720_() == AoAItems.GOLD_COIN.get()) && piglin.m_21206_().m_41619_()) {
            piglin.m_20049_("BarteringForExplosiveIdol");
            piglin.m_8061_(EquipmentSlot.OFFHAND, stack.m_41620_(1));
            piglin.m_21508_(EquipmentSlot.OFFHAND);
            piglin.m_6274_().m_21882_(MemoryModuleType.f_26336_, (Object)true, 121L);
            piglin.m_6274_().m_21936_(MemoryModuleType.f_26370_);
            piglin.m_21573_().m_26573_();
            AoAScheduler.scheduleSyncronisedTask(() -> {
                ItemStack offHandItem;
                if (piglin != null && piglin.m_6084_() && piglin.m_21223_() >= piglin.m_21233_() && ((offHandItem = piglin.m_21120_(InteractionHand.OFF_HAND)).m_41720_() == Items.f_42437_ || offHandItem.m_41720_() == AoAItems.GOLD_COIN.get())) {
                    piglin.m_21008_(InteractionHand.OFF_HAND, Items.f_42417_.m_7968_());
                    piglin.m_6274_().m_21936_(MemoryModuleType.f_26336_);
                }
            }, 120);
        }
    }

    private static void onEntityUpdate(LivingEvent.LivingTickEvent ev) {
        if (ev.getEntity().f_19853_.f_46443_ && ((Boolean)AoAConfigs.CLIENT.partyDeaths.get()).booleanValue() && ev.getEntity().f_20919_ >= 10) {
            AABB boundingBox = ev.getEntity().m_20191_();
            double width = boundingBox.f_82291_ - boundingBox.f_82288_;
            double depth = boundingBox.f_82293_ - boundingBox.f_82290_;
            double height = boundingBox.f_82292_ - boundingBox.f_82289_;
            int i = 0;
            while ((double)i < 3.0 + 10.0 * width * depth * height) {
                ev.getEntity().f_19853_.m_7106_((ParticleOptions)new CustomisableParticleType.Data((ParticleType<CustomisableParticleType.Data>)((ParticleType)AoAParticleTypes.RAINBOW_SPARKLER.get()), 0.1f, 3.0f, 0.0f, 0.0f, 0.0f, 1.0f, -1), boundingBox.f_82288_ + RandomUtil.randomValueUpTo((double)width), boundingBox.f_82289_ + RandomUtil.randomValueUpTo((double)height), boundingBox.f_82290_ + RandomUtil.randomValueUpTo((double)depth), RandomUtil.randomScaledGaussianValue((double)0.05), 0.0, RandomUtil.randomScaledGaussianValue((double)0.05));
                ++i;
            }
        }
    }

    private static void onEntityJoinWorld(EntityJoinLevelEvent ev) {
        if (!ev.getLevel().f_46443_ && WorldUtil.isWorld(ev.getLevel(), AoADimensions.NETHER.key) && ev.getEntity() instanceof WitherBoss && ((WitherBoss)ev.getEntity()).m_31502_() == 220) {
            for (Player pl : ev.getLevel().m_45976_(Player.class, ev.getEntity().m_20191_().m_82400_(50.0))) {
                if (!ItemUtil.findInventoryItem(pl, new ItemStack((ItemLike)AoAItems.BLANK_REALMSTONE.get()), true, 1)) continue;
                ItemUtil.givePlayerItemOrDrop(pl, new ItemStack((ItemLike)AoAItems.ABYSS_REALMSTONE.get()));
            }
        }
    }

    private static void onEntitySpawn(MobSpawnEvent.FinalizeSpawn ev) {
        if (ev.getSpawnType() == MobSpawnType.SPAWNER) {
            ev.getEntity().getPersistentData().m_128379_("spawned_by_spawner", true);
        }
    }

    private static void onEntityExploded(ExplosionEvent.Detonate ev) {
        if (((Boolean)AoAConfigs.SERVER.saveLootFromExplosions.get()).booleanValue()) {
            ev.getAffectedEntities().removeIf(entity -> entity instanceof ItemEntity && entity.f_19797_ < 20);
        }
    }
}

