/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.event;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.event.entity.player.ItemFishedEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.tslat.aoa3.event.custom.events.HaulingItemFishedEvent;
import net.tslat.aoa3.event.custom.events.HaulingRodPullEntityEvent;
import net.tslat.aoa3.event.custom.events.ItemCraftingEvent;
import net.tslat.aoa3.event.custom.events.ItemSmeltingEvent;
import net.tslat.aoa3.event.custom.events.PlayerChangeXpEvent;
import net.tslat.aoa3.event.custom.events.PlayerLevelChangeEvent;
import net.tslat.aoa3.player.AoAPlayerEventListener;
import net.tslat.aoa3.player.ClientPlayerDataManager;
import net.tslat.aoa3.player.ServerPlayerDataManager;
import net.tslat.aoa3.player.ability.AoAAbility;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.PlayerUtil;

public final class AoAPlayerEvents {
    public static void preInit() {
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        forgeBus.addListener(EventPriority.NORMAL, false, TickEvent.PlayerTickEvent.class, AoAPlayerEvents::onPlayerTick);
        forgeBus.addListener(EventPriority.NORMAL, false, LivingEvent.LivingJumpEvent.class, AoAPlayerEvents::onPlayerJump);
        forgeBus.addListener(EventPriority.NORMAL, false, LivingFallEvent.class, AoAPlayerEvents::onPlayerFall);
        forgeBus.addListener(EventPriority.NORMAL, false, LivingDeathEvent.class, AoAPlayerEvents::onEntityDeath);
        forgeBus.addListener(EventPriority.NORMAL, false, BabyEntitySpawnEvent.class, AoAPlayerEvents::onAnimalBreed);
        forgeBus.addListener(EventPriority.NORMAL, false, PlayerEvent.PlayerRespawnEvent.class, AoAPlayerEvents::onPlayerRespawn);
        forgeBus.addListener(EventPriority.NORMAL, false, PlayerEvent.PlayerLoggedInEvent.class, AoAPlayerEvents::onPlayerLogin);
        forgeBus.addListener(EventPriority.NORMAL, false, PlayerEvent.PlayerLoggedOutEvent.class, AoAPlayerEvents::onPlayerLogout);
        forgeBus.addListener(EventPriority.NORMAL, false, PlayerEvent.Clone.class, AoAPlayerEvents::onPlayerDataClone);
        forgeBus.addListener(EventPriority.NORMAL, false, LivingEquipmentChangeEvent.class, AoAPlayerEvents::onPlayerEquipmentChange);
        forgeBus.addListener(EventPriority.NORMAL, false, PlayerEvent.PlayerChangedDimensionEvent.class, AoAPlayerEvents::onDimensionChange);
        forgeBus.addListener(EventPriority.NORMAL, false, PlayerEvent.PlayerChangeGameModeEvent.class, AoAPlayerEvents::onGamemodeChange);
        forgeBus.addListener(EventPriority.NORMAL, false, PlayerEvent.HarvestCheck.class, AoAPlayerEvents::onAttemptBlockHarvest);
        forgeBus.addListener(EventPriority.NORMAL, false, PlayerEvent.BreakSpeed.class, AoAPlayerEvents::onBlockHarvestSpeed);
        forgeBus.addListener(EventPriority.NORMAL, false, BlockEvent.BreakEvent.class, AoAPlayerEvents::onBlockBreak);
        forgeBus.addListener(EventPriority.NORMAL, false, BlockEvent.EntityPlaceEvent.class, AoAPlayerEvents::onBlockPlace);
        forgeBus.addListener(EventPriority.NORMAL, false, PlayerInteractEvent.RightClickBlock.class, AoAPlayerEvents::onBlockInteract);
        forgeBus.addListener(EventPriority.NORMAL, false, ItemTossEvent.class, AoAPlayerEvents::onItemThrow);
        forgeBus.addListener(EventPriority.NORMAL, false, PlayerLevelChangeEvent.class, AoAPlayerEvents::onLevelChange);
        forgeBus.addListener(EventPriority.NORMAL, false, PlayerChangeXpEvent.class, AoAPlayerEvents::onXpGain);
        forgeBus.addListener(EventPriority.NORMAL, false, PlayerXpEvent.XpChange.class, AoAPlayerEvents::onVanillaXpGain);
        forgeBus.addListener(EventPriority.NORMAL, false, ItemCraftingEvent.class, AoAPlayerEvents::onItemCrafting);
        forgeBus.addListener(EventPriority.NORMAL, false, PlayerEvent.ItemCraftedEvent.class, AoAPlayerEvents::onItemCrafted);
        forgeBus.addListener(EventPriority.NORMAL, false, ItemSmeltingEvent.class, AoAPlayerEvents::onItemSmelting);
        forgeBus.addListener(EventPriority.NORMAL, false, PlayerEvent.ItemSmeltedEvent.class, AoAPlayerEvents::onItemSmelted);
        forgeBus.addListener(EventPriority.NORMAL, false, ItemFishedEvent.class, AoAPlayerEvents::onItemFished);
        forgeBus.addListener(EventPriority.NORMAL, false, HaulingRodPullEntityEvent.class, AoAPlayerEvents::onHaulingRodPullEntity);
        forgeBus.addListener(EventPriority.NORMAL, false, MobEffectEvent.Added.class, AoAPlayerEvents::onPotionApplied);
        forgeBus.addListener(EventPriority.NORMAL, false, CriticalHitEvent.class, AoAPlayerEvents::onCriticalHit);
        forgeBus.addListener(EventPriority.NORMAL, false, LivingChangeTargetEvent.class, AoAPlayerEvents::onEntityTargeted);
        forgeBus.addListener(EventPriority.NORMAL, false, LivingAttackEvent.class, AoAPlayerEvents::onPreAttack);
        forgeBus.addListener(EventPriority.NORMAL, false, LivingHurtEvent.class, AoAPlayerEvents::onAttack);
        forgeBus.addListener(EventPriority.NORMAL, false, LivingDamageEvent.class, AoAPlayerEvents::onPostAttack);
    }

    public static void issueEvent(ServerPlayer pl, AoAPlayerEventListener.ListenerType listener, Consumer<? super AoAPlayerEventListener> eventConsumer) {
        PlayerUtil.getAdventPlayer(pl).getListeners(listener).forEach(evListener -> {
            if (evListener.getListenerState() == AoAPlayerEventListener.ListenerState.ACTIVE) {
                eventConsumer.accept((AoAPlayerEventListener)evListener);
            }
        });
    }

    public static void issueClientEvent(AoAPlayerEventListener.ListenerType listener, Consumer<AoAPlayerEventListener> eventConsumer) {
        ClientPlayerDataManager.get().getListeners(listener).forEach(evListener -> {
            if (evListener.getListenerState() == AoAPlayerEventListener.ListenerState.ACTIVE) {
                eventConsumer.accept((AoAPlayerEventListener)evListener);
            }
        });
    }

    public static void issueEvents(ServerPlayer pl, Pair<AoAPlayerEventListener.ListenerType, Consumer<? super AoAPlayerEventListener>> ... listeners) {
        ServerPlayerDataManager plData = PlayerUtil.getAdventPlayer(pl);
        for (Pair<AoAPlayerEventListener.ListenerType, Consumer<? super AoAPlayerEventListener>> listener : listeners) {
            plData.getListeners((AoAPlayerEventListener.ListenerType)((Object)listener.getFirst())).forEach(evListener -> {
                if (evListener.getListenerState() == AoAPlayerEventListener.ListenerState.ACTIVE) {
                    ((Consumer)listener.getSecond()).accept(evListener);
                }
            });
        }
    }

    private static void onPlayerTick(TickEvent.PlayerTickEvent ev) {
        if (ev.phase == TickEvent.Phase.END && ev.player instanceof ServerPlayer) {
            PlayerUtil.getAdventPlayer((ServerPlayer)ev.player).doPlayerTick();
            AoAPlayerEvents.issueEvent((ServerPlayer)ev.player, AoAPlayerEventListener.ListenerType.PLAYER_TICK, listener -> listener.handlePlayerTick(ev));
        }
    }

    private static void onPlayerJump(LivingEvent.LivingJumpEvent ev) {
        if (ev.getEntity() instanceof ServerPlayer) {
            AoAPlayerEvents.issueEvent((ServerPlayer)ev.getEntity(), AoAPlayerEventListener.ListenerType.PLAYER_JUMP, listener -> listener.handlePlayerJump(ev));
        }
    }

    private static void onPlayerFall(LivingFallEvent ev) {
        if (ev.getEntity() instanceof ServerPlayer) {
            AoAPlayerEvents.issueEvent((ServerPlayer)ev.getEntity(), AoAPlayerEventListener.ListenerType.PLAYER_FALL, listener -> listener.handlePlayerFall(ev));
        }
    }

    private static void onEntityDeath(LivingDeathEvent ev) {
        LivingEntity target = ev.getEntity();
        if (target instanceof ServerPlayer) {
            AoAPlayerEvents.issueEvent((ServerPlayer)target, AoAPlayerEventListener.ListenerType.PLAYER_DEATH, listener -> listener.handlePlayerDeath(ev));
        }
        for (Entity pl : EntityUtil.getAttackersForMob(target, entity -> entity != target && entity instanceof ServerPlayer)) {
            AoAPlayerEvents.issueEvent((ServerPlayer)pl, AoAPlayerEventListener.ListenerType.ENTITY_KILL, listener -> listener.handleEntityKill(ev));
        }
    }

    private static void onAnimalBreed(BabyEntitySpawnEvent ev) {
        if (ev.getCausedByPlayer() instanceof ServerPlayer) {
            AoAPlayerEvents.issueEvent((ServerPlayer)ev.getCausedByPlayer(), AoAPlayerEventListener.ListenerType.ANIMAL_BREED, listener -> listener.handleAnimalBreed(ev));
        }
    }

    private static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent ev) {
        if (!ev.isEndConquered() && ev.getEntity() instanceof ServerPlayer) {
            AoAPlayerEvents.issueEvent((ServerPlayer)ev.getEntity(), AoAPlayerEventListener.ListenerType.PLAYER_RESPAWN, listener -> listener.handlePlayerRespawn(ev));
        }
    }

    private static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent ev) {
        if (ev.getEntity() instanceof ServerPlayer) {
            AoAPlayerEvents.issueEvents((ServerPlayer)ev.getEntity(), Pair.of((Object)((Object)AoAPlayerEventListener.ListenerType.PLAYER_LOGIN), listener -> listener.handlePlayerLogin(ev)), Pair.of((Object)((Object)AoAPlayerEventListener.ListenerType.ATTRIBUTE_MODIFIERS), listener -> listener.applyAttributeModifiers(PlayerUtil.getAdventPlayer((ServerPlayer)ev.getEntity()))));
        }
    }

    private static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent ev) {
        if (ev.getEntity() instanceof ServerPlayer) {
            AoAPlayerEvents.issueEvent((ServerPlayer)ev.getEntity(), AoAPlayerEventListener.ListenerType.PLAYER_LOGOUT, listener -> listener.handlePlayerLogout(ev));
        }
    }

    private static void onPlayerDataClone(PlayerEvent.Clone ev) {
        if (ev.getEntity() instanceof ServerPlayer) {
            AoAPlayerEvents.issueEvent((ServerPlayer)ev.getEntity(), AoAPlayerEventListener.ListenerType.PLAYER_CLONE, listener -> listener.handlePlayerDataClone(ev));
            AoAPlayerEvents.issueEvent((ServerPlayer)ev.getEntity(), AoAPlayerEventListener.ListenerType.ATTRIBUTE_MODIFIERS, listener -> listener.applyAttributeModifiers(PlayerUtil.getAdventPlayer((ServerPlayer)ev.getEntity())));
        }
    }

    private static void onPlayerEquipmentChange(LivingEquipmentChangeEvent ev) {
        if (ev.getEntity() instanceof ServerPlayer) {
            AoAPlayerEvents.issueEvent((ServerPlayer)ev.getEntity(), AoAPlayerEventListener.ListenerType.EQUIPMENT_CHANGE, listener -> listener.handleArmourChange(ev));
        }
    }

    private static void onDimensionChange(PlayerEvent.PlayerChangedDimensionEvent ev) {
        if (ev.getEntity() instanceof ServerPlayer) {
            AoAPlayerEvents.issueEvent((ServerPlayer)ev.getEntity(), AoAPlayerEventListener.ListenerType.DIMENSION_CHANGE, listener -> listener.handleDimensionChange(ev));
        }
    }

    private static void onGamemodeChange(PlayerEvent.PlayerChangeGameModeEvent ev) {
        if (ev.getEntity() instanceof ServerPlayer) {
            AoAPlayerEvents.issueEvent((ServerPlayer)ev.getEntity(), AoAPlayerEventListener.ListenerType.GAMEMODE_CHANGE, listener -> listener.handleGamemodeChange(ev));
        }
    }

    private static void onAttemptBlockHarvest(PlayerEvent.HarvestCheck ev) {
        if (ev.getEntity() instanceof ServerPlayer) {
            AoAPlayerEvents.issueEvent((ServerPlayer)ev.getEntity(), AoAPlayerEventListener.ListenerType.BLOCK_HARVEST_ATTEMPT, listener -> listener.handleBlockHarvestAttempt(ev));
        }
    }

    private static void onBlockHarvestSpeed(PlayerEvent.BreakSpeed ev) {
        if (ev.getEntity() instanceof ServerPlayer) {
            AoAPlayerEvents.issueEvent((ServerPlayer)ev.getEntity(), AoAPlayerEventListener.ListenerType.BLOCK_BREAK_SPEED, listener -> listener.handleHarvestSpeedCheck(ev));
        } else {
            AoAPlayerEvents.issueClientEvent(AoAPlayerEventListener.ListenerType.BLOCK_BREAK_SPEED, listener -> listener.handleHarvestSpeedCheck(ev));
        }
    }

    private static void onBlockBreak(BlockEvent.BreakEvent ev) {
        if (ev.getPlayer() instanceof ServerPlayer) {
            AoAPlayerEvents.issueEvent((ServerPlayer)ev.getPlayer(), AoAPlayerEventListener.ListenerType.BLOCK_BREAK, listener -> listener.handleBlockBreak(ev));
        }
    }

    private static void onBlockPlace(BlockEvent.EntityPlaceEvent ev) {
        if (ev.getEntity() instanceof ServerPlayer) {
            AoAPlayerEvents.issueEvent((ServerPlayer)ev.getEntity(), AoAPlayerEventListener.ListenerType.BLOCK_PLACE, listener -> listener.handleBlockPlacement(ev));
        }
    }

    private static void onBlockInteract(PlayerInteractEvent.RightClickBlock ev) {
        if (ev.getEntity() instanceof ServerPlayer) {
            AoAPlayerEvents.issueEvent((ServerPlayer)ev.getEntity(), AoAPlayerEventListener.ListenerType.BLOCK_INTERACT, listener -> listener.handleBlockInteraction(ev));
        }
    }

    private static void onItemThrow(ItemTossEvent ev) {
        if (ev.getPlayer() instanceof ServerPlayer) {
            AoAPlayerEvents.issueEvent((ServerPlayer)ev.getPlayer(), AoAPlayerEventListener.ListenerType.ITEM_THROW, listener -> listener.handleItemToss(ev));
        }
    }

    private static void onLevelChange(PlayerLevelChangeEvent ev) {
        if (ev.getEntity() instanceof ServerPlayer) {
            AoAPlayerEvents.issueEvent((ServerPlayer)ev.getEntity(), AoAPlayerEventListener.ListenerType.LEVEL_CHANGE, listener -> listener.handleLevelChange(ev));
        }
    }

    private static void onXpGain(PlayerChangeXpEvent ev) {
        if (ev.getEntity() instanceof ServerPlayer) {
            AoAPlayerEvents.issueEvent((ServerPlayer)ev.getEntity(), AoAPlayerEventListener.ListenerType.GAIN_SKILL_XP, listener -> listener.handleSkillXpGain(ev));
        }
    }

    private static void onVanillaXpGain(PlayerXpEvent.XpChange ev) {
        if (ev.getEntity() instanceof ServerPlayer) {
            AoAPlayerEvents.issueEvent((ServerPlayer)ev.getEntity(), AoAPlayerEventListener.ListenerType.GAIN_VANILLA_XP, listener -> listener.handleVanillaXpGain(ev));
        }
    }

    private static void onItemCrafting(ItemCraftingEvent ev) {
        if (ev.getEntity() instanceof ServerPlayer) {
            AoAPlayerEvents.issueEvent((ServerPlayer)ev.getEntity(), AoAPlayerEventListener.ListenerType.ITEM_CRAFTING, listener -> listener.handleItemCrafting(ev));
        }
    }

    private static void onItemCrafted(PlayerEvent.ItemCraftedEvent ev) {
        if (ev.getEntity() instanceof ServerPlayer) {
            AoAPlayerEvents.issueEvent((ServerPlayer)ev.getEntity(), AoAPlayerEventListener.ListenerType.ITEM_CRAFTED, listener -> listener.handleItemCrafted(ev));
        } else {
            AoAPlayerEvents.issueClientEvent(AoAPlayerEventListener.ListenerType.ITEM_CRAFTED, listener -> listener.handleItemCrafted(ev));
        }
    }

    private static void onItemSmelting(ItemSmeltingEvent ev) {
        if (ev.getEntity() instanceof ServerPlayer) {
            AoAPlayerEvents.issueEvent((ServerPlayer)ev.getEntity(), AoAPlayerEventListener.ListenerType.ITEM_SMELTING, listener -> listener.handleItemSmelting(ev));
        } else {
            AoAPlayerEvents.issueClientEvent(AoAPlayerEventListener.ListenerType.ITEM_SMELTING, listener -> listener.handleItemSmelting(ev));
        }
    }

    private static void onItemSmelted(PlayerEvent.ItemSmeltedEvent ev) {
        if (ev.getEntity() instanceof ServerPlayer) {
            AoAPlayerEvents.issueEvent((ServerPlayer)ev.getEntity(), AoAPlayerEventListener.ListenerType.ITEM_SMELTED, listener -> listener.handleItemSmelted(ev));
        } else {
            AoAPlayerEvents.issueClientEvent(AoAPlayerEventListener.ListenerType.ITEM_SMELTED, listener -> listener.handleItemSmelted(ev));
        }
    }

    private static void onItemFished(ItemFishedEvent ev) {
        if (ev.getEntity() instanceof ServerPlayer) {
            AoAPlayerEvents.issueEvent((ServerPlayer)ev.getEntity(), AoAPlayerEventListener.ListenerType.FISHED_ITEM, listener -> listener.handleItemFished(ev, ev instanceof HaulingItemFishedEvent));
        }
    }

    private static void onHaulingRodPullEntity(HaulingRodPullEntityEvent ev) {
        if (ev.getEntity() instanceof ServerPlayer) {
            AoAPlayerEvents.issueEvent((ServerPlayer)ev.getEntity(), AoAPlayerEventListener.ListenerType.HAULING_ROD_PULL_ENTITY, listener -> listener.handleHaulingRodPullEntity(ev));
        }
    }

    private static void onPotionApplied(MobEffectEvent.Added ev) {
        if (ev.getEntity() instanceof ServerPlayer) {
            AoAPlayerEvents.issueEvent((ServerPlayer)ev.getEntity(), AoAPlayerEventListener.ListenerType.POTION_APPLIED, listener -> listener.handleAppliedPotion(ev));
        }
    }

    private static void onCriticalHit(CriticalHitEvent ev) {
        if (ev.isVanillaCritical() && ev.getEntity() instanceof ServerPlayer) {
            AoAPlayerEvents.issueEvent((ServerPlayer)ev.getEntity(), AoAPlayerEventListener.ListenerType.CRITICAL_HIT, listener -> listener.handleCriticalHit(ev));
        }
    }

    private static void onEntityTargeted(LivingChangeTargetEvent ev) {
        if (ev.getNewTarget() instanceof ServerPlayer) {
            AoAPlayerEvents.issueEvent((ServerPlayer)ev.getNewTarget(), AoAPlayerEventListener.ListenerType.ENTITY_TARGET, listener -> listener.handleEntityTarget(ev));
        }
    }

    private static void onPreAttack(LivingAttackEvent ev) {
        if (ev.getEntity() instanceof ServerPlayer) {
            AoAPlayerEvents.issueEvent((ServerPlayer)ev.getEntity(), AoAPlayerEventListener.ListenerType.INCOMING_ATTACK_BEFORE, listener -> listener.handlePreIncomingAttack(ev));
        } else if (ev.getSource().m_7639_() instanceof ServerPlayer) {
            AoAPlayerEvents.issueEvent((ServerPlayer)ev.getSource().m_7639_(), AoAPlayerEventListener.ListenerType.OUTGOING_ATTACK_BEFORE, listener -> listener.handlePreOutgoingAttack(ev));
        }
    }

    private static void onAttack(LivingHurtEvent ev) {
        if (ev.getEntity() instanceof ServerPlayer) {
            AoAPlayerEvents.issueEvent((ServerPlayer)ev.getEntity(), AoAPlayerEventListener.ListenerType.INCOMING_ATTACK_DURING, listener -> listener.handleIncomingAttack(ev));
        } else if (ev.getSource().m_7639_() instanceof ServerPlayer) {
            AoAPlayerEvents.issueEvent((ServerPlayer)ev.getSource().m_7639_(), AoAPlayerEventListener.ListenerType.OUTGOING_ATTACK_DURING, listener -> listener.handleOutgoingAttack(ev));
        }
    }

    private static void onPostAttack(LivingDamageEvent ev) {
        if (ev.getEntity() instanceof ServerPlayer) {
            AoAPlayerEvents.issueEvent((ServerPlayer)ev.getEntity(), AoAPlayerEventListener.ListenerType.INCOMING_ATTACK_AFTER, listener -> listener.handlePostIncomingAttack(ev));
        } else if (ev.getSource().m_7639_() instanceof ServerPlayer) {
            AoAPlayerEvents.issueEvent((ServerPlayer)ev.getSource().m_7639_(), AoAPlayerEventListener.ListenerType.OUTGOING_ATTACK_AFTER, listener -> listener.handlePostOutgoingAttack(ev));
        }
    }

    public static void onKeyPress(ServerPlayer player, List<String> abilityListeners) {
        ServerPlayerDataManager plData = PlayerUtil.getAdventPlayer(player);
        for (String str : abilityListeners) {
            AoAAbility.Instance ability = plData.getAbility(str);
            if (ability == null) continue;
            ability.handleKeyInput();
        }
    }

    public static void handleCustomInteraction(ServerPlayer player, String interactionType, Object data) {
        AoAPlayerEvents.issueEvent(player, AoAPlayerEventListener.ListenerType.CUSTOM, listener -> listener.handleCustomInteraction(interactionType, data));
    }
}

