/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.data.server;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.advent.Logging;
import net.tslat.aoa3.event.dimension.NowhereEvents;
import net.tslat.aoa3.util.AdvancementUtil;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.LootUtil;
import org.apache.logging.log4j.Level;

public class AoANowhereParkourCourseListener
extends SimpleJsonResourceReloadListener {
    private static final Int2ObjectMap<List<NowhereParkourCourse>> REGISTERED_COURSES = new Int2ObjectOpenHashMap();
    private static final String folder = "worldgen/nowhere_parkour_courses";

    public AoANowhereParkourCourseListener() {
        super(new GsonBuilder().setPrettyPrinting().create(), folder);
    }

    protected void apply(Map<ResourceLocation, JsonElement> entryMap, ResourceManager resourceManager, ProfilerFiller profiler) {
        REGISTERED_COURSES.clear();
        for (Map.Entry<ResourceLocation, JsonElement> entry : entryMap.entrySet()) {
            Either result = NowhereParkourCourse.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)entry.getValue()).get();
            if (result.right().isPresent()) {
                Logging.logMessage(Level.ERROR, "Unable to deserialize parkour course data, disabling. (" + entry.getKey() + ") " + ((DataResult.PartialResult)result.right().get()).message());
                continue;
            }
            NowhereParkourCourse parkourCourse = (NowhereParkourCourse)result.left().get();
            if (parkourCourse.playerStart == null) {
                Logging.logMessage(Level.ERROR, "No player start point provided for parkour course, disabling course. " + entry.getKey());
                continue;
            }
            REGISTERED_COURSES.computeIfAbsent(parkourCourse.getTier(), key -> new ObjectArrayList());
            ((List)REGISTERED_COURSES.get(parkourCourse.getTier())).add(parkourCourse);
        }
    }

    @Nullable
    public static NowhereParkourCourse getCourseForPosition(ServerLevel level, Vec3 pos) {
        if (!NowhereEvents.isInParkourRegion(BlockPos.m_274446_((Position)pos))) {
            return null;
        }
        int tier = ((int)pos.f_82479_ - 500) / 500;
        if (!REGISTERED_COURSES.containsKey(tier)) {
            return null;
        }
        for (NowhereParkourCourse course : (List)REGISTERED_COURSES.get(tier)) {
            if (!course.isOnCourse(level, pos)) continue;
            return course;
        }
        return null;
    }

    @Nullable
    public static NowhereParkourCourse getNextCourse(NowhereParkourCourse currentCourse) {
        List sameTierCourses = (List)REGISTERED_COURSES.get(currentCourse.getTier());
        for (int i = 0; i < sameTierCourses.size(); ++i) {
            if (sameTierCourses.get(i) != currentCourse) continue;
            return i == sameTierCourses.size() - 1 ? null : (NowhereParkourCourse)sameTierCourses.get(i + 1);
        }
        return null;
    }

    @Nullable
    public static NowhereParkourCourse getFirstCourseForTier(int tier) {
        return REGISTERED_COURSES.containsKey(tier) ? (NowhereParkourCourse)((List)REGISTERED_COURSES.get(tier)).get(0) : null;
    }

    public static class NowhereParkourCourse {
        public static final Codec<NowhereParkourCourse> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)ResourceLocation.f_135803_.fieldOf("structure_id").forGetter(course -> course.structureId), (App)BlockPos.f_121852_.fieldOf("structure_pos").forGetter(course -> course.structurePos), (App)Vec3.f_231074_.fieldOf("player_start").forGetter(course -> course.playerStart), (App)Codec.INT.fieldOf("tier").forGetter(course -> course.tier), (App)ResourceLocation.f_135803_.optionalFieldOf("reward_table").forGetter(course -> course.rewardLootTable)).apply((Applicative)builder, NowhereParkourCourse::new));
        public final ResourceLocation structureId;
        private final BlockPos structurePos;
        private final Vec3 playerStart;
        private final int tier;
        private final Optional<ResourceLocation> rewardLootTable;
        private Structure structure = null;
        private StructureStart structureStart = null;
        private AABB structureBounds = null;

        public NowhereParkourCourse(ResourceLocation structureId, BlockPos structurePos, Vec3 playerStart, int tier, Optional<ResourceLocation> rewardTable) {
            this.structureId = structureId;
            this.structurePos = structurePos;
            this.playerStart = playerStart;
            this.tier = tier;
            this.rewardLootTable = rewardTable;
        }

        public int getTier() {
            return this.tier;
        }

        @Nullable
        private Structure getStructure(ServerLevel level) {
            if (this.structure != null) {
                return this.structure;
            }
            this.structure = (Structure)((Registry)level.m_9598_().m_6632_(Registries.f_256944_).get()).m_7745_(this.structureId);
            return this.structure;
        }

        @Nullable
        private StructureStart getStructureStart(ServerLevel level) {
            if (this.structureStart != null) {
                return this.structureStart;
            }
            Structure structure = this.getStructure(level);
            if (structure == null) {
                return null;
            }
            this.structureStart = level.m_215010_().m_220494_(this.structurePos, structure);
            return this.structureStart;
        }

        @Nullable
        public AABB getStructureBounds(ServerLevel level) {
            if (this.structureBounds != null) {
                return this.structureBounds;
            }
            StructureStart structureStart = this.getStructureStart(level);
            if (structureStart == null) {
                return null;
            }
            this.structureBounds = AABB.m_82321_((BoundingBox)structureStart.m_73601_());
            return this.structureBounds;
        }

        public boolean isOnCourse(ServerLevel level, Vec3 position) {
            AABB bounds = this.getStructureBounds(level);
            return bounds != null && bounds.m_82390_(position);
        }

        public void grantRewards(ServerPlayer player) {
            this.rewardLootTable.ifPresent(tableId -> {
                ServerLevel level = player.m_9236_();
                ItemUtil.givePlayerMultipleItems((Player)player, LootUtil.generateLoot(level, tableId, LootUtil.getGiftContext(level, player.m_20182_(), player.m_36336_(), (Entity)player)));
            });
            player.m_8960_().m_135988_(AdvancementUtil.getAdvancement(AdventOfAscension.id("nowhere/tier_" + this.tier + "_acrobat")), "complete_course");
        }

        public void teleportPlayerToCourse(ServerPlayer player) {
            player.f_8906_.m_9774_(this.playerStart.f_82479_, this.playerStart.f_82480_, this.playerStart.f_82481_, player.m_146908_(), player.m_146909_());
        }
    }
}

