/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.data.server;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.registries.ForgeRegistries;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.advent.Logging;
import net.tslat.aoa3.common.registration.custom.AoASkills;
import net.tslat.aoa3.library.object.GenericEntryPool;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.util.PlayerUtil;
import net.tslat.aoa3.util.RegistryUtil;
import net.tslat.aoa3.util.TagUtil;

public class AoAHaulingFishReloadListener
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String folder = "player/misc/hauling_fish";
    private static final FishEntryRetriever FISH_RETRIEVER = new FishEntryRetriever();
    private static final FishEntryRetriever TRAPS_RETRIEVER = new FishEntryRetriever();

    public AoAHaulingFishReloadListener() {
        super(GSON, folder);
    }

    public static GenericEntryPool<Function<Level, Entity>, ServerPlayer> getFishListForBiome(Biome biome, boolean isLava, Level level) {
        return FISH_RETRIEVER.getEntityList(biome, isLava, level);
    }

    public static GenericEntryPool<Function<Level, Entity>, ServerPlayer> getTrapListForBiome(Biome biome, boolean isLava, Level level) {
        return TRAPS_RETRIEVER.getEntityList(biome, isLava, level);
    }

    protected void apply(Map<ResourceLocation, JsonElement> jsonMap, ResourceManager resourceManager, ProfilerFiller profiler) {
        FISH_RETRIEVER.reset();
        TRAPS_RETRIEVER.reset();
        for (Map.Entry<ResourceLocation, JsonElement> entry : jsonMap.entrySet()) {
            ResourceLocation id = entry.getKey();
            JsonObject obj = entry.getValue().getAsJsonObject();
            if (id.equals((Object)AdventOfAscension.id("fish_default"))) {
                this.parseEntityList(GsonHelper.m_13933_((JsonObject)obj, (String)"entities"), AoAHaulingFishReloadListener.FISH_RETRIEVER.WATER_FALLBACK, false);
                continue;
            }
            if (id.equals((Object)AdventOfAscension.id("fish_lava_default"))) {
                this.parseEntityList(GsonHelper.m_13933_((JsonObject)obj, (String)"entities"), AoAHaulingFishReloadListener.FISH_RETRIEVER.LAVA_FALLBACK, true);
                continue;
            }
            if (id.equals((Object)AdventOfAscension.id("traps_default"))) {
                this.parseEntityList(GsonHelper.m_13933_((JsonObject)obj, (String)"entities"), AoAHaulingFishReloadListener.TRAPS_RETRIEVER.WATER_FALLBACK, false);
                continue;
            }
            if (id.equals((Object)AdventOfAscension.id("traps_lava_default"))) {
                this.parseEntityList(GsonHelper.m_13933_((JsonObject)obj, (String)"entities"), AoAHaulingFishReloadListener.TRAPS_RETRIEVER.LAVA_FALLBACK, true);
                continue;
            }
            try {
                this.parseEntry(obj.getAsJsonObject());
            }
            catch (IllegalArgumentException ex) {
                Logging.logMessage(org.apache.logging.log4j.Level.WARN, "Invalid Hauling fish json: " + entry.getKey().toString(), ex);
            }
        }
    }

    private void parseEntry(JsonObject json) throws IllegalArgumentException {
        GenericEntryPool<Function<Level, Entity>, ServerPlayer> list;
        FishEntryRetriever retriever;
        boolean replace = GsonHelper.m_13855_((JsonObject)json, (String)"replace", (boolean)false);
        ObjectArrayList tags = new ObjectArrayList();
        ObjectArrayList biomes = new ObjectArrayList();
        boolean forLava = GsonHelper.m_13855_((JsonObject)json, (String)"for_lava", (boolean)false);
        boolean forTraps = GsonHelper.m_13855_((JsonObject)json, (String)"for_traps", (boolean)false);
        if (json.has("tags")) {
            JsonArray tagArray = json.getAsJsonArray("tags");
            for (JsonElement element : tagArray) {
                tags.add(TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation(element.getAsString())));
            }
        }
        if (json.has("biomes")) {
            JsonArray biomeArray = json.getAsJsonArray("biomes");
            for (JsonElement element : biomeArray) {
                biomes.add(ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation(element.getAsString())));
            }
        }
        if (tags.isEmpty() && biomes.isEmpty()) {
            throw new IllegalArgumentException("No biome tags or biome ids listed, must have one or the other.");
        }
        FishEntryRetriever fishEntryRetriever = retriever = forTraps ? TRAPS_RETRIEVER : FISH_RETRIEVER;
        if (!tags.isEmpty()) {
            for (TagKey tag : tags) {
                list = retriever.getOrCreateBiomePool(forLava, tag);
                if (replace) {
                    list.clear();
                }
                this.parseEntityList(json.get("entities").getAsJsonArray(), list, forLava);
            }
        }
        if (!biomes.isEmpty()) {
            for (ResourceKey biome : biomes) {
                list = retriever.getOrCreateBiomePool(forLava, biome);
                if (replace) {
                    list.clear();
                }
                this.parseEntityList(json.get("entities").getAsJsonArray(), list, forLava);
            }
        }
    }

    private void parseEntityList(JsonArray array, GenericEntryPool<Function<Level, Entity>, ServerPlayer> list, final boolean forLava) {
        Predicate<ServerPlayer> fallbackPredicate = player -> true;
        for (JsonElement element : array) {
            Function<Level, Entity> factory;
            if (!element.isJsonObject()) continue;
            JsonObject obj = element.getAsJsonObject();
            int weight = GsonHelper.m_13824_((JsonObject)obj, (String)"weight", (int)1);
            Predicate<ServerPlayer> predicate = obj.has("level") ? pl -> PlayerUtil.doesPlayerHaveLevel((Player)pl, (AoASkill)AoASkills.HAULING.get(), obj.get("level").getAsInt()) : fallbackPredicate;
            float weightMod = GsonHelper.m_13820_((JsonObject)obj, (String)"weight_mod", (float)0.0f);
            if (obj.has("item")) {
                Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(obj.get("item").getAsString()));
                if (item == null) continue;
                factory = world -> {
                    ItemEntity entity = new ItemEntity(EntityType.f_20461_, (Level)world){

                        public boolean m_5825_() {
                            return forLava || super.m_5825_();
                        }
                    };
                    entity.m_32045_(new ItemStack((ItemLike)item));
                    entity.m_32062_();
                    return entity;
                };
            } else {
                EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(obj.get("entity").getAsString()));
                if (entityType == null) continue;
                factory = arg_0 -> ((EntityType)entityType).m_20615_(arg_0);
            }
            list.add(factory, predicate, weight, weightMod);
        }
    }

    private static class FishEntryRetriever {
        private final GenericEntryPool<Function<Level, Entity>, ServerPlayer> WATER_FALLBACK = new GenericEntryPool();
        private final GenericEntryPool<Function<Level, Entity>, ServerPlayer> LAVA_FALLBACK = new GenericEntryPool();
        private Object2ObjectOpenHashMap<Object, GenericEntryPool<Function<Level, Entity>, ServerPlayer>> WATER_MAP = null;
        private Object2ObjectOpenHashMap<Object, GenericEntryPool<Function<Level, Entity>, ServerPlayer>> LAVA_MAP = null;

        private FishEntryRetriever() {
        }

        private GenericEntryPool<Function<Level, Entity>, ServerPlayer> getOrCreateBiomePool(boolean forLava, Object biomeOrTag) {
            if (forLava) {
                if (this.LAVA_MAP == null) {
                    this.LAVA_MAP = new Object2ObjectOpenHashMap();
                }
                return (GenericEntryPool)this.LAVA_MAP.computeIfAbsent(biomeOrTag, biome -> new GenericEntryPool());
            }
            if (this.WATER_MAP == null) {
                this.WATER_MAP = new Object2ObjectOpenHashMap();
            }
            return (GenericEntryPool)this.WATER_MAP.computeIfAbsent(biomeOrTag, biome -> new GenericEntryPool());
        }

        private GenericEntryPool<Function<Level, Entity>, ServerPlayer> getEntityList(Biome biome, boolean isLava, Level level) {
            return isLava ? this.getLavaEntry(biome, level) : this.getWaterEntry(biome, level);
        }

        private GenericEntryPool<Function<Level, Entity>, ServerPlayer> getLavaEntry(Biome biome, Level level) {
            ResourceKey resourceKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)ForgeRegistries.BIOMES.getKey((Object)biome));
            GenericEntryPool entry = (GenericEntryPool)this.LAVA_MAP.get((Object)resourceKey);
            if (entry != null) {
                return entry;
            }
            TagKey matchedTag = TagUtil.getAllTagsFor(Registries.f_256952_, biome, level).filter(tag -> this.LAVA_MAP.containsKey(tag)).findFirst().orElse(null);
            if (matchedTag != null) {
                return (GenericEntryPool)this.LAVA_MAP.get((Object)matchedTag);
            }
            return this.LAVA_FALLBACK;
        }

        private GenericEntryPool<Function<Level, Entity>, ServerPlayer> getWaterEntry(Biome biome, Level level) {
            ResourceKey resourceKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)RegistryUtil.getId(biome));
            GenericEntryPool entry = (GenericEntryPool)this.WATER_MAP.get((Object)resourceKey);
            if (entry != null) {
                return entry;
            }
            TagKey matchedTag = TagUtil.getAllTagsFor(Registries.f_256952_, biome, level).filter(tag -> this.WATER_MAP.containsKey(tag)).findFirst().orElse(null);
            if (matchedTag != null) {
                return (GenericEntryPool)this.WATER_MAP.get((Object)matchedTag);
            }
            return this.WATER_FALLBACK;
        }

        private void reset() {
            this.WATER_FALLBACK.clear();
            this.LAVA_FALLBACK.clear();
            this.WATER_MAP = null;
            this.LAVA_MAP = null;
        }
    }
}

