/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.data.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.Unit;
import net.minecraft.util.profiling.ProfilerFiller;
import net.tslat.aoa3.util.StringUtil;

public class AdventGuiThemeReloadListener
implements PreparableReloadListener {
    private static final ArrayList<AdventGuiTheme> THEMES = new ArrayList(7);
    private static int pointer = -1;

    public CompletableFuture<Void> m_5540_(PreparableReloadListener.PreparationBarrier stage, ResourceManager resourceManager, ProfilerFiller preparationsProfiler, ProfilerFiller reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
        return stage.m_6769_((Object)Unit.INSTANCE).thenRunAsync(() -> this.handleResourcesReload(resourceManager, reloadProfiler));
    }

    private void handleResourcesReload(ResourceManager resourceManager, ProfilerFiller reloadProfiler) {
        THEMES.clear();
        HashMap<String, ResourceLocation[]> textures = new HashMap<String, ResourceLocation[]>();
        textures.put("default", new ResourceLocation[3]);
        for (ResourceLocation resourceLocation : resourceManager.m_214159_("textures/gui/adventgui/themes", path -> path.m_135815_().endsWith(".png")).keySet()) {
            int subfolderIndexEnd;
            int subfolderIndexStart = resourceLocation.m_135815_().indexOf("themes/") + 7;
            if (subfolderIndexStart == (subfolderIndexEnd = resourceLocation.m_135815_().lastIndexOf("/"))) continue;
            String theme = resourceLocation.m_135815_().substring(subfolderIndexStart, subfolderIndexEnd);
            ResourceLocation[] themeTextures = textures.getOrDefault(theme, new ResourceLocation[3]);
            switch (resourceLocation.m_135815_().substring(subfolderIndexEnd + 1)) {
                case "background.png": {
                    themeTextures[0] = resourceLocation;
                    break;
                }
                case "tab_buttons.png": {
                    themeTextures[1] = resourceLocation;
                    break;
                }
                case "overlay.png": {
                    themeTextures[2] = resourceLocation;
                }
            }
            textures.put(theme, themeTextures);
        }
        for (Map.Entry entry : textures.entrySet()) {
            ResourceLocation[] paths = (ResourceLocation[])entry.getValue();
            THEMES.add(new AdventGuiTheme(StringUtil.toTitleCase((String)entry.getKey()), paths[0], paths[1], paths[2]));
        }
    }

    public static AdventGuiTheme getNextTheme() {
        if (++pointer >= THEMES.size()) {
            pointer = 0;
        }
        return THEMES.get(pointer);
    }

    public static AdventGuiTheme setTheme(String name) {
        pointer = 0;
        for (int i = 0; i < THEMES.size(); ++i) {
            if (!THEMES.get(i).name().equals(name)) continue;
            pointer = i;
            break;
        }
        return THEMES.get(pointer);
    }

    public record AdventGuiTheme(String name, ResourceLocation backgroundTexture, ResourceLocation menuButtonTexture, @Nullable ResourceLocation overlayTexture) {
        public AdventGuiTheme(String name, @Nullable ResourceLocation backgroundTexture, @Nullable ResourceLocation menuButtonTexture, @Nullable ResourceLocation overlayTexture) {
            this.name = name;
            this.backgroundTexture = backgroundTexture == null ? new ResourceLocation("aoa3", "textures/gui/adventgui/themes/default/background.png") : backgroundTexture;
            this.menuButtonTexture = menuButtonTexture == null ? new ResourceLocation("aoa3", "textures/gui/adventgui/themes/default/tab_buttons.png") : menuButtonTexture;
            this.overlayTexture = overlayTexture;
        }
    }
}

