/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.world.spawner;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.event.ForgeEventFactory;
import net.tslat.aoa3.content.world.spawner.AoACustomSpawner;
import net.tslat.smartbrainlib.util.RandomUtil;

public class RoamingTraderSpawner
implements AoACustomSpawner {
    public static final Codec<RoamingTraderSpawner> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)IntProvider.f_146531_.fieldOf("spawn_interval").forGetter(spawner -> spawner.spawnInterval), (App)IntProvider.f_146531_.fieldOf("extra_delay_per_spawn").forGetter(spawner -> spawner.extraDelayPerSpawn), (App)Codec.FLOAT.fieldOf("chance_per_player").forGetter(spawner -> Float.valueOf(spawner.chancePerPlayer)), (App)IntProvider.f_146531_.fieldOf("spawns_per_player").forGetter(spawner -> spawner.spawnsPerPlayer), (App)Biome.f_47432_.optionalFieldOf("biome_blacklist").forGetter(spawner -> spawner.biomeBlacklist), (App)ResourceLocation.f_135803_.listOf().xmap(Set::copyOf, List::copyOf).fieldOf("dimension_blacklist").forGetter(spawner -> spawner.dimensionBlacklist), (App)WeightedRandomList.m_146333_((Codec)MobSpawnSettings.SpawnerData.f_48403_).fieldOf("spawns").forGetter(spawner -> spawner.spawns), (App)SpawnData.CustomSpawnRules.f_186583_.optionalFieldOf("spawn_rules").forGetter(spawner -> spawner.spawnRules), (App)Codec.BOOL.fieldOf("spawn_in_flat_world").forGetter(spawner -> spawner.spawnInFlatWorld)).apply((Applicative)builder, RoamingTraderSpawner::new));
    private final IntProvider spawnInterval;
    private final IntProvider extraDelayPerSpawn;
    private final float chancePerPlayer;
    private final IntProvider spawnsPerPlayer;
    private final Optional<HolderSet<Biome>> biomeBlacklist;
    private final Set<ResourceLocation> dimensionBlacklist;
    private final WeightedRandomList<MobSpawnSettings.SpawnerData> spawns;
    private final Optional<SpawnData.CustomSpawnRules> spawnRules;
    private final boolean spawnInFlatWorld;
    private long nextSpawnTick = -1L;

    public RoamingTraderSpawner(IntProvider spawnInterval, IntProvider extraDelayPerSpawn, float chancePerPlayer, IntProvider spawnsPerPlayer, Optional<HolderSet<Biome>> biomeBlacklist, Set<ResourceLocation> dimensionBlacklist, WeightedRandomList<MobSpawnSettings.SpawnerData> spawns, Optional<SpawnData.CustomSpawnRules> spawnRules, boolean spawnInFlatWorld) {
        this.spawnInterval = spawnInterval;
        this.extraDelayPerSpawn = extraDelayPerSpawn;
        this.chancePerPlayer = chancePerPlayer;
        this.spawnsPerPlayer = spawnsPerPlayer;
        this.biomeBlacklist = biomeBlacklist;
        this.dimensionBlacklist = dimensionBlacklist;
        this.spawns = spawns;
        this.spawnRules = spawnRules;
        this.spawnInFlatWorld = spawnInFlatWorld;
    }

    @Override
    public boolean shouldAddToDimension(ServerLevel level) {
        return (!level.m_8584_() || this.spawnInFlatWorld) && !this.dimensionBlacklist.contains(level.m_46472_().m_135782_());
    }

    public int m_7995_(ServerLevel level, boolean spawnHostiles, boolean spawnPassives) {
        if (this.nextSpawnTick > level.m_46467_() || !spawnPassives || !level.m_46469_().m_46207_(GameRules.f_46125_)) {
            return 0;
        }
        RandomSource random = level.m_213780_();
        this.nextSpawnTick = level.m_46467_() + (long)this.spawnInterval.m_214085_(random);
        return this.doSpawning(level, random);
    }

    private int doSpawning(ServerLevel level, RandomSource random) {
        int count = 0;
        for (ServerPlayer pl2 : level.m_8795_(pl -> !pl.m_5833_() && pl.m_6084_())) {
            if (level.m_213780_().m_188501_() >= this.chancePerPlayer) continue;
            for (Pair<EntityType<?>, BlockPos> spawn : this.findNearbySpawnPositions(level, random, pl2.m_20183_(), 20, 64, this.spawnsPerPlayer.m_214085_(random))) {
                Entity entity;
                SpawnData.CustomSpawnRules spawnRules;
                BlockPos pos = (BlockPos)spawn.getSecond();
                if (this.spawnRules.isPresent() && (!((EntityType)spawn.getFirst()).m_20674_().m_21609_() && level.m_46791_() == Difficulty.PEACEFUL || !(spawnRules = this.spawnRules.get()).f_186584_().m_184578_((Comparable)Integer.valueOf(level.m_45517_(LightLayer.BLOCK, pos))) || !spawnRules.f_186585_().m_184578_((Comparable)Integer.valueOf(level.m_45517_(LightLayer.SKY, pos)))) || (entity = ((EntityType)spawn.getFirst()).m_262451_(level, null, null, pos, MobSpawnType.NATURAL, false, false)) == null) continue;
                if (entity instanceof Mob) {
                    Mob mob = (Mob)entity;
                    if (this.spawnRules.isEmpty() && !mob.m_5545_((LevelAccessor)level, MobSpawnType.NATURAL) || !mob.m_6914_((LevelReader)level)) continue;
                    ForgeEventFactory.onFinalizeSpawn((Mob)mob, (ServerLevelAccessor)level, (DifficultyInstance)level.m_6436_(pos), (MobSpawnType)MobSpawnType.NATURAL, null, null);
                }
                level.m_47205_(entity);
                this.nextSpawnTick += (long)this.extraDelayPerSpawn.m_214085_(random);
                ++count;
            }
        }
        return count;
    }

    private List<Pair<EntityType<?>, BlockPos>> findNearbySpawnPositions(ServerLevel level, RandomSource random, BlockPos centerPos, int minRadius, int maxRadius, int maxTries) {
        ObjectArrayList positions = new ObjectArrayList();
        RandomUtil.EasyRandom rand = new RandomUtil.EasyRandom(random);
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        float radius = Math.max(maxRadius - minRadius, 0);
        for (int i = 0; i < maxTries; ++i) {
            this.spawns.m_216829_(random).ifPresent(arg_0 -> RoamingTraderSpawner.lambda$findNearbySpawnPositions$11(rand, radius, centerPos, mutablePos, level, (List)positions, arg_0));
        }
        return positions;
    }

    private static /* synthetic */ void lambda$findNearbySpawnPositions$11(RandomUtil.EasyRandom rand, float radius, BlockPos centerPos, BlockPos.MutableBlockPos mutablePos, ServerLevel level, List positions, MobSpawnSettings.SpawnerData spawn) {
        double xAdjust = rand.randomValueBetween((double)(-radius), (double)radius);
        double zAdjust = rand.randomValueBetween((double)(-radius), (double)radius);
        int newX = (int)Math.floor((double)centerPos.m_123341_() + xAdjust + (double)radius * Math.signum(xAdjust));
        int newZ = (int)Math.floor((double)centerPos.m_123343_() + zAdjust + (double)radius * Math.signum(zAdjust));
        SpawnPlacements.Type placementType = SpawnPlacements.m_21752_((EntityType)spawn.f_48404_);
        Heightmap.Types heightmap = SpawnPlacements.m_21765_((EntityType)spawn.f_48404_);
        mutablePos.m_122190_((Vec3i)level.m_5452_(heightmap, (BlockPos)mutablePos.m_122178_(newX, 0, newZ)));
        if (level.m_6042_().f_63856_()) {
            while (!level.m_8055_((BlockPos)mutablePos.m_122173_(Direction.DOWN)).m_60795_()) {
            }
            while (level.m_8055_((BlockPos)mutablePos.m_122173_(Direction.DOWN)).m_60795_() && mutablePos.m_123342_() > level.m_141937_()) {
            }
        }
        if (NaturalSpawner.m_47051_((SpawnPlacements.Type)placementType, (LevelReader)level, (BlockPos)mutablePos, (EntityType)spawn.f_48404_) && level.m_45772_(spawn.f_48404_.m_20585_((double)mutablePos.m_123341_() + 0.5, (double)mutablePos.m_123342_(), (double)mutablePos.m_123343_() + 0.5))) {
            positions.add(Pair.of((Object)spawn.f_48404_, (Object)mutablePos.m_7949_()));
        }
    }
}

