/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.world.genold.feature.features.trees;

import com.mojang.serialization.Codec;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.content.block.functional.plant.SaplingBlock;
import net.tslat.aoa3.content.world.genold.feature.features.trees.AoAVariableLeafTreeFeature;
import net.tslat.aoa3.content.world.genold.feature.placement.config.BlockStatePlacementConfig;

public abstract class ShyreTreeFeature
extends AoAVariableLeafTreeFeature {
    public ShyreTreeFeature(Codec<BlockStatePlacementConfig> codec, Supplier<SaplingBlock> saplingBlock) {
        super(codec, saplingBlock);
    }

    @Override
    protected boolean generateTree(WorldGenLevel reader, RandomSource rand, BlockPos pos, BlockState leafBlock, boolean isWorldGen) {
        int i;
        int trunkHeight = 5 + rand.m_188503_(5);
        if (!this.checkSafeHeight(reader, pos, trunkHeight + 3, 1, isWorldGen)) {
            return false;
        }
        if (!this.checkAndPrepSoil(reader, pos, 1, isWorldGen)) {
            return false;
        }
        BlockPos.MutableBlockPos movablePos = new BlockPos.MutableBlockPos().m_122190_((Vec3i)pos.m_7495_());
        BlockState log = ((Block)AoABlocks.SHYRE_LOG.get()).m_49966_();
        for (i = 0; i < trunkHeight; ++i) {
            this.placeBlock(reader, (BlockPos)movablePos.m_122173_(Direction.UP), log);
        }
        switch (rand.m_188503_(4)) {
            case 0: {
                for (i = 0; i >= -2 - rand.m_188503_(2); --i) {
                    this.placeBlock(reader, movablePos.m_7918_(-1, i, 0), leafBlock);
                    this.placeBlock(reader, movablePos.m_7918_(1, i, 0), leafBlock);
                    this.placeBlock(reader, movablePos.m_7918_(0, i, 1), leafBlock);
                    this.placeBlock(reader, movablePos.m_7918_(0, i, -1), leafBlock);
                }
                this.placeBlock(reader, movablePos.m_7918_(0, 1, 0), leafBlock);
                break;
            }
            case 1: {
                for (int y = 0; y >= -1 - rand.m_188503_(2); --y) {
                    for (int x = -1; x <= 1; ++x) {
                        for (int z = -1; z <= 1; ++z) {
                            this.placeBlock(reader, movablePos.m_7918_(x, y, z), leafBlock);
                        }
                    }
                }
                this.placeBlock(reader, movablePos.m_7918_(0, 1, 0), leafBlock);
                this.placeBlock(reader, movablePos.m_7918_(1, 1, 0), leafBlock);
                this.placeBlock(reader, movablePos.m_7918_(0, 1, 1), leafBlock);
                this.placeBlock(reader, movablePos.m_7918_(-1, 1, 0), leafBlock);
                this.placeBlock(reader, movablePos.m_7918_(0, 1, -1), leafBlock);
                break;
            }
            case 2: {
                for (int x = -1; x <= 1; ++x) {
                    for (int y = 1; y <= 3; y += 2) {
                        for (int z = -1; z <= 1; ++z) {
                            this.placeBlock(reader, movablePos.m_7918_(x, y, z), leafBlock);
                        }
                    }
                }
                this.placeBlock(reader, movablePos.m_7918_(-1, 2, -1), leafBlock);
                this.placeBlock(reader, movablePos.m_7918_(1, 2, 1), leafBlock);
                this.placeBlock(reader, movablePos.m_7918_(-1, 2, 1), leafBlock);
                this.placeBlock(reader, movablePos.m_7918_(1, 2, -1), leafBlock);
                break;
            }
            case 3: {
                for (i = 0; i <= 3; ++i) {
                    if (i == 1) continue;
                    this.placeBlock(reader, movablePos.m_7918_(-1, i, 0), leafBlock);
                    this.placeBlock(reader, movablePos.m_7918_(1, i, 0), leafBlock);
                    this.placeBlock(reader, movablePos.m_7918_(0, i, 1), leafBlock);
                    this.placeBlock(reader, movablePos.m_7918_(0, i, -1), leafBlock);
                }
                this.placeBlock(reader, movablePos.m_7918_(0, 1, 0), leafBlock);
            }
        }
        return true;
    }
}

