/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.world.genold.feature.features.trees;

import com.mojang.serialization.Codec;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.content.block.functional.plant.SaplingBlock;
import net.tslat.aoa3.content.world.genold.feature.features.trees.AoATreeFeature;
import net.tslat.aoa3.content.world.genold.feature.placement.config.BlockStatePlacementConfig;

public class LucalusTreeFeature
extends AoATreeFeature {
    public LucalusTreeFeature(Codec<BlockStatePlacementConfig> codec, Supplier<SaplingBlock> saplingBlock) {
        super(codec, saplingBlock);
    }

    @Override
    protected boolean generateTree(WorldGenLevel reader, RandomSource rand, BlockPos pos, boolean isWorldGen) {
        int z;
        int x;
        if ((pos = this.findMultiSaplingPosition(reader, rand, pos, 2, isWorldGen)) == null) {
            return false;
        }
        int trunkHeight = 16 + rand.m_188503_(16);
        if (!this.checkSafeHeight(reader, pos, trunkHeight + 2, 2, isWorldGen)) {
            return false;
        }
        if (!this.checkAndPrepSoil(reader, pos, 2, isWorldGen)) {
            return false;
        }
        BlockState baseSoil = reader.m_8055_(pos.m_7495_());
        for (int x2 = 0; x2 < 2; ++x2) {
            for (int z2 = 0; z2 < 2; ++z2) {
                BlockPos testPos = pos.m_7918_(x2, -1, z2);
                if (!reader.m_8055_(testPos).m_60713_(Blocks.f_50016_)) continue;
                reader.m_7731_(testPos, baseSoil, 2);
            }
        }
        BlockState log = ((Block)AoABlocks.LUCALUS_LOG.get()).m_49966_();
        BlockState leaves = ((Block)AoABlocks.LUCALUS_LEAVES.get()).m_49966_();
        int northBranchGap = 0;
        int southBranchGap = 0;
        int eastBranchGap = 0;
        int westBranchGap = 0;
        for (int i = 0; i < trunkHeight; ++i) {
            for (int x3 = 0; x3 <= 1; ++x3) {
                for (int z3 = 0; z3 <= 1; ++z3) {
                    this.placeBlock(reader, pos.m_7918_(x3, i, z3), log);
                    if (i >= trunkHeight - 2) continue;
                    if (northBranchGap > 4 && rand.m_188503_(4) == 0) {
                        northBranchGap = 0;
                        this.buildNorthSouthBranch(reader, pos.m_7918_(0, i, 0), rand, true);
                    }
                    if (eastBranchGap > 4 && rand.m_188503_(4) == 0) {
                        eastBranchGap = 0;
                        this.buildEastWestBranch(reader, pos.m_7918_(0, i, 0), rand, true);
                    }
                    if (southBranchGap > 4 && rand.m_188503_(4) == 0) {
                        southBranchGap = 0;
                        this.buildNorthSouthBranch(reader, pos.m_7918_(0, i, 0), rand, false);
                    }
                    if (westBranchGap <= 4 || rand.m_188503_(4) != 0) continue;
                    westBranchGap = 0;
                    this.buildEastWestBranch(reader, pos.m_7918_(0, i, 0), rand, false);
                }
            }
            ++northBranchGap;
            ++southBranchGap;
            ++eastBranchGap;
            ++westBranchGap;
        }
        for (x = -1; x <= 2; ++x) {
            for (z = -1; z <= 2; ++z) {
                if ((x == -1 || x == 2) && (z == -1 || z == 2)) continue;
                this.placeBlock(reader, pos.m_7918_(x, trunkHeight - 1, z), leaves);
            }
        }
        for (x = -2; x <= 3; ++x) {
            for (z = -2; z <= 3; ++z) {
                if ((x == -2 || x == 3) && (z == -2 || z == 3)) continue;
                this.placeBlock(reader, pos.m_7918_(x, trunkHeight, z), leaves);
            }
        }
        this.placeBlock(reader, pos.m_7918_(0, trunkHeight + 1, 0), leaves);
        this.placeBlock(reader, pos.m_7918_(1, trunkHeight + 1, 0), leaves);
        this.placeBlock(reader, pos.m_7918_(0, trunkHeight + 1, 1), leaves);
        this.placeBlock(reader, pos.m_7918_(1, trunkHeight + 1, 1), leaves);
        return true;
    }

    private void buildNorthSouthBranch(WorldGenLevel reader, BlockPos branchPos, RandomSource rand, boolean north) {
        BlockState log = ((Block)AoABlocks.LUCALUS_LOG.get()).m_49966_();
        BlockState leaves = ((Block)AoABlocks.LUCALUS_LEAVES.get()).m_49966_();
        int branchLength = 3 + rand.m_188503_(2);
        if (north) {
            for (int i = 0; i < branchLength; ++i) {
                this.placeBlock(reader, branchPos.m_7918_(0, i, 2 + i), log);
                this.placeBlock(reader, branchPos.m_7918_(1, i, 2 + i), log);
            }
            int leafMod = 2 + rand.m_188503_(3);
            for (int z = -2; z <= 2; ++z) {
                for (int x = -2; x <= 3; ++x) {
                    for (int y = 1; y <= 3; ++y) {
                        int x2 = x;
                        if (x > 0) {
                            --x2;
                        }
                        if (Math.abs(x2) > leafMod - Math.abs(z) - y) continue;
                        this.placeBlock(reader, branchPos.m_7918_(x, branchLength - 2 + y, branchLength + 1 + z), leaves);
                    }
                }
            }
        } else {
            for (int i = 0; i < branchLength; ++i) {
                this.placeBlock(reader, branchPos.m_7918_(0, i, -1 - i), log);
                this.placeBlock(reader, branchPos.m_7918_(1, i, -1 - i), log);
            }
            int leafMod = 2 + rand.m_188503_(3);
            for (int z = -2; z <= 2; ++z) {
                for (int x = -2; x <= 3; ++x) {
                    for (int y = 1; y <= 3; ++y) {
                        int x2 = x;
                        if (x > 0) {
                            --x2;
                        }
                        if (Math.abs(x2) > leafMod - Math.abs(z) - y) continue;
                        this.placeBlock(reader, branchPos.m_7918_(x, branchLength - 2 + y, -branchLength + -z), leaves);
                    }
                }
            }
        }
    }

    private void buildEastWestBranch(WorldGenLevel reader, BlockPos branchPos, RandomSource rand, boolean east) {
        BlockState log = ((Block)AoABlocks.LUCALUS_LOG.get()).m_49966_();
        BlockState leaves = ((Block)AoABlocks.LUCALUS_LEAVES.get()).m_49966_();
        int branchLength = 3 + rand.m_188503_(2);
        if (east) {
            for (int i = 0; i < branchLength; ++i) {
                this.placeBlock(reader, branchPos.m_7918_(2 + i, i, 0), log);
                this.placeBlock(reader, branchPos.m_7918_(2 + i, i, 1), log);
            }
            int leafMod = 2 + rand.m_188503_(3);
            for (int x = -2; x <= 2; ++x) {
                for (int z = -2; z <= 3; ++z) {
                    for (int y = 1; y <= 3; ++y) {
                        int z2 = z;
                        if (z > 0) {
                            --z2;
                        }
                        if (Math.abs(z2) > leafMod - Math.abs(x) - y) continue;
                        this.placeBlock(reader, branchPos.m_7918_(branchLength + 1 + x, branchLength - 2 + y, z), leaves);
                    }
                }
            }
        } else {
            for (int i = 0; i < branchLength; ++i) {
                this.placeBlock(reader, branchPos.m_7918_(-1 - i, i, 0), log);
                this.placeBlock(reader, branchPos.m_7918_(-1 - i, i, 1), log);
            }
            int leafMod = 2 + rand.m_188503_(3);
            for (int x = -2; x <= 2; ++x) {
                for (int z = -2; z <= 3; ++z) {
                    for (int y = 1; y <= 3; ++y) {
                        int z2 = z;
                        if (z > 0) {
                            --z2;
                        }
                        if (Math.abs(z2) > leafMod - Math.abs(x) - y) continue;
                        this.placeBlock(reader, branchPos.m_7918_(-branchLength + -x, branchLength - 2 + y, z), leaves);
                    }
                }
            }
        }
    }
}

