/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.world.genold.feature.features.trees;

import com.mojang.serialization.Codec;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.content.block.functional.plant.SaplingBlock;
import net.tslat.aoa3.content.world.genold.feature.features.trees.AoATreeFeature;
import net.tslat.aoa3.content.world.genold.feature.placement.config.BlockStatePlacementConfig;

public class IrodustTreeFeature
extends AoATreeFeature {
    public IrodustTreeFeature(Codec<BlockStatePlacementConfig> codec, Supplier<SaplingBlock> saplingBlock) {
        super(codec, saplingBlock);
    }

    @Override
    protected boolean generateTree(WorldGenLevel reader, RandomSource rand, BlockPos pos, boolean isWorldGen) {
        if (rand.m_188499_()) {
            return this.generateTree1(reader, rand, pos, isWorldGen);
        }
        return this.generateTree2(reader, rand, pos, isWorldGen);
    }

    private boolean generateTree1(WorldGenLevel reader, RandomSource rand, BlockPos pos, boolean isWorldGen) {
        int trunkHeight = 8 + rand.m_188503_(6);
        if (!this.checkSafeHeight(reader, pos, trunkHeight + 1, 1, isWorldGen)) {
            return false;
        }
        if (!this.checkAndPrepSoil(reader, pos, 1, isWorldGen)) {
            return false;
        }
        BlockPos.MutableBlockPos movablePos = new BlockPos.MutableBlockPos().m_122190_((Vec3i)pos.m_7495_());
        BlockState log = ((Block)AoABlocks.IROLOG.get()).m_49966_();
        BlockState leaves = ((Block)AoABlocks.IRODUST_LEAVES.get()).m_49966_();
        for (int i = 0; i < trunkHeight; ++i) {
            this.placeBlock(reader, (BlockPos)movablePos.m_122173_(Direction.UP), log);
        }
        int treeWidth = 1 + rand.m_188503_(2);
        for (int x = -treeWidth - 1; x <= treeWidth + 1; ++x) {
            for (int z = -treeWidth - 1; z <= treeWidth + 1; ++z) {
                if (Math.abs(x) != treeWidth + 1 && Math.abs(z) != treeWidth + 1) {
                    this.placeBlock(reader, movablePos.m_7918_(x, 1, z), leaves);
                    continue;
                }
                this.placeBlock(reader, movablePos.m_7918_(x, 0, z), leaves);
            }
        }
        this.buildLeafRing(reader, movablePos.m_7918_(0, -1, 0), treeWidth + 1, true);
        return true;
    }

    private boolean generateTree2(WorldGenLevel reader, RandomSource rand, BlockPos pos, boolean isWorldGen) {
        int trunkHeight = 8 + rand.m_188503_(6);
        if (!this.checkSafeHeight(reader, pos, trunkHeight + 2, 1, isWorldGen)) {
            return false;
        }
        if (!this.checkAndPrepSoil(reader, pos, 1, isWorldGen)) {
            return false;
        }
        BlockPos.MutableBlockPos movablePos = new BlockPos.MutableBlockPos().m_122190_((Vec3i)pos.m_7495_());
        BlockState log = ((Block)AoABlocks.IROLOG.get()).m_49966_();
        BlockState leaves = ((Block)AoABlocks.IRODUST_LEAVES.get()).m_49966_();
        for (int i = 0; i < trunkHeight; ++i) {
            this.placeBlock(reader, (BlockPos)movablePos.m_122173_(Direction.UP), log);
        }
        this.buildLeafRing(reader, movablePos.m_7918_(0, (int)Math.floor(-((double)trunkHeight / 1.75)), 0), 3, false);
        this.buildLeafRing(reader, movablePos.m_7918_(0, -(trunkHeight / 4), 0), 2, true);
        for (int x = -1; x <= 1; ++x) {
            for (int y = 0; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    this.placeBlock(reader, movablePos.m_7918_(x, y, z), leaves);
                }
            }
        }
        return true;
    }

    private void buildLeafRing(WorldGenLevel reader, BlockPos pos, int radius, boolean fullRing) {
        BlockState log = ((Block)AoABlocks.IROLOG.get()).m_49966_();
        BlockState leaves = ((Block)AoABlocks.IRODUST_LEAVES.get()).m_49966_();
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                if (Math.abs(x) == radius || Math.abs(z) == radius) {
                    if (!fullRing && Math.abs(x) == radius && Math.abs(z) == radius) continue;
                    this.placeBlock(reader, pos.m_7918_(x, 0, z), leaves);
                    continue;
                }
                if (!(x == 0 ^ z == 0)) continue;
                this.placeBlock(reader, pos.m_7918_(x, 0, z), log);
            }
        }
    }
}

