/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.world.genold.feature.features.trees;

import com.mojang.serialization.Codec;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.content.block.functional.plant.SaplingBlock;
import net.tslat.aoa3.content.world.genold.feature.features.trees.AoATreeFeature;
import net.tslat.aoa3.content.world.genold.feature.placement.config.BlockStatePlacementConfig;

public class InvertedChurryTreeFeature
extends AoATreeFeature {
    public InvertedChurryTreeFeature(Codec<BlockStatePlacementConfig> codec, Supplier<SaplingBlock> saplingBlock) {
        super(codec, saplingBlock);
    }

    @Override
    protected boolean checkSafeHeight(WorldGenLevel reader, BlockPos pos, int maxHeight, int trunkWidth, boolean isWorldGen) {
        return pos.m_123342_() <= 256 && pos.m_123342_() - maxHeight >= 1;
    }

    @Override
    protected boolean generateTree(WorldGenLevel reader, RandomSource rand, BlockPos pos, boolean isWorldGen) {
        int trunkHeight = 25 + rand.m_188503_(15);
        if (!this.checkSafeHeight(reader, pos, trunkHeight + 3, 1, isWorldGen)) {
            return false;
        }
        BlockPos.MutableBlockPos movablePos = new BlockPos.MutableBlockPos().m_122190_((Vec3i)pos.m_7494_());
        BlockState log = ((Block)AoABlocks.CHURRY_LOG.get()).m_49966_();
        BlockState lelyetianLeaves = ((Block)AoABlocks.LELYETIAN_LEAVES.get()).m_49966_();
        int leafGap = 0;
        for (int i = 0; i < trunkHeight; ++i) {
            this.placeBlock(reader, (BlockPos)movablePos.m_122173_(Direction.DOWN), log);
            if (i <= 6 || ++leafGap <= 6 || leafGap <= 11 && rand.m_188503_(5) != 0) continue;
            leafGap = 0;
            this.buildLeafBlob(reader, movablePos.m_7949_(), rand);
        }
        this.placeBlock(reader, (BlockPos)movablePos.m_122173_(Direction.DOWN), log);
        for (int x = -1; x <= 1; ++x) {
            for (int y = 1; y <= 3; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    this.placeBlock(reader, movablePos.m_7918_(x, -y, z), lelyetianLeaves);
                }
            }
        }
        return true;
    }

    private void buildLeafBlob(WorldGenLevel reader, BlockPos pos, RandomSource rand) {
        int x;
        BlockState leaves = ((Block)AoABlocks.CHURRY_LEAVES.get()).m_49966_();
        this.placeBlock(reader, pos.m_122012_(), leaves);
        this.placeBlock(reader, pos.m_122019_(), leaves);
        this.placeBlock(reader, pos.m_122029_(), leaves);
        this.placeBlock(reader, pos.m_122024_(), leaves);
        for (x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                if (x == 0 && z == 0) continue;
                this.placeBlock(reader, pos.m_7918_(x, 1, z), leaves);
            }
        }
        for (x = -2; x <= 2; ++x) {
            for (int y = -2; y >= -3; --y) {
                for (int z = -2; z <= 2; ++z) {
                    if ((x == 2 || x == -2) && (z == 2 || z == -2)) continue;
                    this.placeBlock(reader, pos.m_7918_(x, -y, z), leaves);
                }
            }
        }
        pos = pos.m_6630_(3);
        this.placeBlock(reader, pos.m_122013_(3), leaves);
        this.placeBlock(reader, pos.m_122020_(3), leaves);
        this.placeBlock(reader, pos.m_122030_(3), leaves);
        this.placeBlock(reader, pos.m_122025_(3), leaves);
        if (rand.m_188499_()) {
            this.placeBlock(reader, pos.m_122013_(4), leaves);
            this.placeBlock(reader, pos.m_122020_(4), leaves);
            this.placeBlock(reader, pos.m_122030_(4), leaves);
            this.placeBlock(reader, pos.m_122025_(4), leaves);
        }
        this.placeBlock(reader, pos.m_122012_(), leaves);
        this.placeBlock(reader, pos.m_122019_(), leaves);
        this.placeBlock(reader, pos.m_122029_(), leaves);
        this.placeBlock(reader, pos.m_122024_(), leaves);
    }
}

