/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.world.genold.feature.features.trees;

import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.content.block.functional.plant.SaplingBlock;
import net.tslat.aoa3.content.world.genold.feature.features.trees.AoATreeFeature;
import net.tslat.aoa3.content.world.genold.feature.placement.config.BlockStatePlacementConfig;

public class HauntedTreeFeature
extends AoATreeFeature {
    private final int hauntedLeafChance = 80;
    private final int hauntedLogChance = 25;
    private final int purplingLogChance = 20;

    public HauntedTreeFeature(Codec<BlockStatePlacementConfig> codec, Supplier<SaplingBlock> saplingBlock) {
        super(codec, saplingBlock);
    }

    @Override
    protected boolean generateTree(WorldGenLevel reader, RandomSource rand, BlockPos pos, boolean isWorldGen) {
        return switch (rand.m_188503_(4)) {
            case 0 -> this.generateTree1(reader, rand, pos, isWorldGen);
            case 1 -> this.generateTree2(reader, rand, pos, isWorldGen);
            case 2 -> this.generateTree3(reader, rand, pos, isWorldGen);
            case 3 -> this.generateTree4(reader, rand, pos, isWorldGen);
            default -> true;
        };
    }

    private boolean generateTree1(WorldGenLevel reader, RandomSource rand, BlockPos pos, boolean isWorldGen) {
        int trunkHeight = 24;
        if (!this.checkSafeHeight(reader, pos, trunkHeight + 1, 1, isWorldGen)) {
            return false;
        }
        if (!this.checkAndPrepSoil(reader, pos, 1, isWorldGen)) {
            return false;
        }
        BlockPos.MutableBlockPos movablePos = new BlockPos.MutableBlockPos().m_122190_((Vec3i)pos.m_7495_());
        BlockState log = rand.m_188503_(20) == 0 ? ((Block)AoABlocks.HAUNTED_PURPLING_LOG.get()).m_49966_() : ((Block)AoABlocks.HAUNTED_LOG.get()).m_49966_();
        BlockState redEyesLog = ((Block)AoABlocks.HAUNTED_EYES_LOG.get()).m_49966_();
        BlockState eyeLog = ((Block)AoABlocks.HAUNTED_EYE_LOG.get()).m_49966_();
        BlockState leaves = ((Block)AoABlocks.HAUNTED_LEAVES.get()).m_49966_();
        BlockState eyeLeaves = ((Block)AoABlocks.HAUNTED_EYES_LEAVES.get()).m_49966_();
        for (int i = 0; i < trunkHeight; ++i) {
            BlockState logBlock = rand.m_188503_(25) == 0 ? (rand.m_188499_() ? eyeLog : redEyesLog) : log;
            this.placeBlock(reader, (BlockPos)movablePos.m_122173_(Direction.UP), logBlock);
        }
        this.generateCrossBranch(reader, rand, pos.m_6630_(5), log, 6);
        this.generateCrossBranch(reader, rand, pos.m_6630_(10), log, 5);
        this.generateCrossBranch(reader, rand, pos.m_6630_(15), log, 4);
        this.generateCrossBranch(reader, rand, pos.m_6630_(19), log, 3);
        this.generateCrossBranch(reader, rand, pos.m_6630_(23), log, 2);
        this.placeBlock(reader, pos.m_7918_(0, 24, 0), rand.m_188503_(80) == 0 ? eyeLeaves : leaves);
        return true;
    }

    private boolean generateTree2(WorldGenLevel reader, RandomSource rand, BlockPos pos, boolean isWorldGen) {
        BlockState leafBlock;
        int z;
        int x;
        int i;
        int trunkHeight = 12 + rand.m_188503_(5);
        if (!this.checkSafeHeight(reader, pos, trunkHeight + 1, 1, isWorldGen)) {
            return false;
        }
        if (!this.checkAndPrepSoil(reader, pos, 1, isWorldGen)) {
            return false;
        }
        BlockPos.MutableBlockPos movablePos = new BlockPos.MutableBlockPos().m_122190_((Vec3i)pos.m_7495_());
        BlockState log = rand.m_188503_(20) == 0 ? ((Block)AoABlocks.HAUNTED_PURPLING_LOG.get()).m_49966_() : ((Block)AoABlocks.HAUNTED_LOG.get()).m_49966_();
        BlockState redEyesLog = ((Block)AoABlocks.HAUNTED_EYES_LOG.get()).m_49966_();
        BlockState eyeLog = ((Block)AoABlocks.HAUNTED_EYE_LOG.get()).m_49966_();
        BlockState leaves = ((Block)AoABlocks.HAUNTED_LEAVES.get()).m_49966_();
        BlockState eyeLeaves = ((Block)AoABlocks.HAUNTED_EYES_LEAVES.get()).m_49966_();
        for (int i2 = 0; i2 < trunkHeight; ++i2) {
            BlockState logBlock = rand.m_188503_(25) == 0 ? (rand.m_188499_() ? eyeLog : redEyesLog) : log;
            this.placeBlock(reader, (BlockPos)movablePos.m_122173_(Direction.UP), logBlock);
        }
        int coreHeight = 3 + rand.m_188503_(3);
        int bottomCoreHeight = 3 + rand.m_188503_(3);
        for (i = 0; i < coreHeight; ++i) {
            for (x = -1; x <= 1; ++x) {
                for (z = -1; z <= 1; ++z) {
                    leafBlock = rand.m_188503_(80) == 0 ? eyeLeaves : leaves;
                    this.placeBlock(reader, movablePos.m_7918_(x, -i, z), leafBlock);
                }
            }
        }
        for (i = 0; i < bottomCoreHeight; ++i) {
            for (x = -2; x <= 2; ++x) {
                for (z = -2; z <= 2; ++z) {
                    leafBlock = rand.m_188503_(80) == 0 ? eyeLeaves : leaves;
                    this.placeBlock(reader, movablePos.m_7918_(x, -coreHeight + -i, z), leafBlock);
                }
            }
        }
        for (i = -3; i <= 3; i += 6) {
            for (int j = -1; j <= 1; j += 2) {
                int y;
                for (y = 0; y <= 2 + rand.m_188503_(3); ++y) {
                    leafBlock = rand.m_188503_(80) == 0 ? eyeLeaves : leaves;
                    this.placeBlock(reader, movablePos.m_7918_(i, -coreHeight + y, j), leafBlock);
                }
                for (y = 0; y <= 2 + rand.m_188503_(3); ++y) {
                    leafBlock = rand.m_188503_(80) == 0 ? eyeLeaves : leaves;
                    this.placeBlock(reader, movablePos.m_7918_(j, -coreHeight + y, i), leafBlock);
                }
            }
        }
        for (i = 1; i <= 1 + rand.m_188503_(3); ++i) {
            BlockState leafBlock2 = rand.m_188503_(80) == 0 ? eyeLeaves : leaves;
            this.placeBlock(reader, movablePos.m_7918_(0, i, 0), leafBlock2);
        }
        return true;
    }

    private boolean generateTree3(WorldGenLevel reader, RandomSource rand, BlockPos pos, boolean isWorldGen) {
        int trunkHeight = 10 + rand.m_188503_(6);
        if (!this.checkSafeHeight(reader, pos, trunkHeight, 1, isWorldGen)) {
            return false;
        }
        if (!this.checkAndPrepSoil(reader, pos, 1, isWorldGen)) {
            return false;
        }
        BlockPos.MutableBlockPos movablePos = new BlockPos.MutableBlockPos().m_122190_((Vec3i)pos.m_7495_());
        boolean purpling = rand.m_188503_(20) == 0;
        BlockState log = purpling ? ((Block)AoABlocks.HAUNTED_PURPLING_LOG.get()).m_49966_() : ((Block)AoABlocks.HAUNTED_LOG.get()).m_49966_();
        BlockState redEyesLog = ((Block)AoABlocks.HAUNTED_EYES_LOG.get()).m_49966_();
        BlockState eyeLog = ((Block)AoABlocks.HAUNTED_EYE_LOG.get()).m_49966_();
        BlockState leaves = ((Block)AoABlocks.HAUNTED_LEAVES.get()).m_49966_();
        BlockState eyeLeaves = ((Block)AoABlocks.HAUNTED_EYES_LEAVES.get()).m_49966_();
        HashMap<Direction, Integer> branchOffsetMap = new HashMap<Direction, Integer>(4);
        for (int i = 0; i < trunkHeight; ++i) {
            BlockState logBlock = rand.m_188503_(25) == 0 ? (rand.m_188499_() ? eyeLog : redEyesLog) : log;
            this.placeBlock(reader, (BlockPos)movablePos.m_122173_(Direction.UP), logBlock);
            if (i <= 3) continue;
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                if (branchOffsetMap.containsKey(dir) && i - (Integer)branchOffsetMap.get(dir) <= 3 || rand.m_188503_(3) != 0) continue;
                branchOffsetMap.put(dir, i);
                for (int j = 1; j <= 4; ++j) {
                    BlockPos branchLocPos = movablePos.m_5484_(dir, j);
                    BlockState branchLogBlock = rand.m_188503_(25) == 0 ? (rand.m_188499_() ? eyeLog : redEyesLog) : log;
                    BlockState barkBlock = this.getBarkForLog(branchLogBlock);
                    this.placeBlock(reader, branchLocPos, barkBlock);
                    if (j <= 1) continue;
                    if (j == 2 || j == 4) {
                        BlockState branchLogBlock2 = rand.m_188503_(25) == 0 ? (rand.m_188499_() ? eyeLog : redEyesLog) : log;
                        this.placeBlock(reader, branchLocPos.m_7495_(), branchLogBlock2);
                    }
                    Direction sidewaysDir = dir.m_122428_();
                    branchLocPos = branchLocPos.m_6625_(2);
                    for (int k = -1; k <= 1; ++k) {
                        BlockState leafBlock = rand.m_188503_(80) == 0 ? eyeLeaves : leaves;
                        BlockPos newPos = branchLocPos.m_5484_(sidewaysDir, k);
                        this.placeBlock(reader, newPos, leafBlock);
                        if (rand.m_188503_(100) != 0 || !reader.m_8055_(newPos = newPos.m_7495_()).m_60795_()) continue;
                        this.placeBlock(reader, newPos, ((Block)AoABlocks.MAGIC_MARANG_CROP.get()).m_49966_());
                    }
                }
            }
        }
        return true;
    }

    private boolean generateTree4(WorldGenLevel reader, RandomSource rand, BlockPos pos, boolean isWorldGen) {
        BlockState logBlock;
        int i;
        int trunkHeight = 7 + rand.m_188503_(7);
        if (!this.checkSafeHeight(reader, pos, trunkHeight + 3, 1, isWorldGen)) {
            return false;
        }
        if (!this.checkAndPrepSoil(reader, pos, 1, isWorldGen)) {
            return false;
        }
        BlockPos.MutableBlockPos movablePos = new BlockPos.MutableBlockPos().m_122190_((Vec3i)pos.m_7495_());
        BlockState log = rand.m_188503_(20) == 0 ? ((Block)AoABlocks.HAUNTED_PURPLING_LOG.get()).m_49966_() : ((Block)AoABlocks.HAUNTED_LOG.get()).m_49966_();
        BlockState redEyesLog = ((Block)AoABlocks.HAUNTED_EYES_LOG.get()).m_49966_();
        BlockState eyeLog = ((Block)AoABlocks.HAUNTED_EYE_LOG.get()).m_49966_();
        BlockState leaves = ((Block)AoABlocks.HAUNTED_LEAVES.get()).m_49966_();
        BlockState eyeLeaves = ((Block)AoABlocks.HAUNTED_EYES_LEAVES.get()).m_49966_();
        for (i = 0; i < trunkHeight; ++i) {
            logBlock = rand.m_188503_(25) == 0 ? (rand.m_188499_() ? eyeLog : redEyesLog) : log;
            this.placeBlock(reader, (BlockPos)movablePos.m_122173_(Direction.UP), logBlock);
        }
        for (i = -2; i <= 2; ++i) {
            BlockState logBlock3;
            BlockState blockState = rand.m_188503_(25) == 0 ? (rand.m_188499_() ? eyeLog : redEyesLog) : (logBlock = log);
            BlockState logBlock2 = rand.m_188503_(25) == 0 ? (rand.m_188499_() ? eyeLog : redEyesLog) : log;
            BlockState barkBlock = this.getBarkForLog(logBlock);
            BlockState barkBlock2 = this.getBarkForLog(logBlock2);
            this.placeBlock(reader, movablePos.m_7918_(i, 1, 0), barkBlock);
            this.placeBlock(reader, movablePos.m_7918_(0, 1, i), barkBlock2);
            if (Math.abs(i) != 2) continue;
            BlockState blockState2 = rand.m_188503_(25) == 0 ? (rand.m_188499_() ? eyeLog : redEyesLog) : (logBlock3 = log);
            BlockState logBlock4 = rand.m_188503_(25) == 0 ? (rand.m_188499_() ? eyeLog : redEyesLog) : log;
            this.placeBlock(reader, movablePos.m_7918_(i, 2, 0), logBlock3);
            this.placeBlock(reader, movablePos.m_7918_(0, 2, i), logBlock4);
        }
        for (int x = -4; x <= 4; ++x) {
            for (int z = -4; z <= 4; ++z) {
                if (x * x + z * z > 16 - (3 - Math.abs(x) - Math.abs(z))) continue;
                BlockState leafBlock = rand.m_188503_(80) == 0 ? eyeLeaves : leaves;
                BlockPos leafPos = movablePos.m_7918_(x, 3, z);
                this.placeBlock(reader, leafPos, leafBlock);
                if (Math.abs(x) <= 2 && Math.abs(z) <= 2 || rand.m_188503_(5) != 0) continue;
                for (int i2 = 1; i2 <= 3 + rand.m_188503_(3); ++i2) {
                    BlockState leafBlock2 = rand.m_188503_(80) == 0 ? eyeLeaves : leaves;
                    this.placeBlock(reader, leafPos.m_7918_(0, -i2, 0), leafBlock2);
                }
            }
        }
        return true;
    }

    private void generateCrossBranch(WorldGenLevel reader, RandomSource rand, BlockPos branchPos, BlockState log, int length) {
        BlockState barkLog = this.getBarkForLog(log);
        BlockState redEyesBarkLog = ((Block)AoABlocks.HAUNTED_EYES_WOOD.get()).m_49966_();
        BlockState eyeBarkLog = ((Block)AoABlocks.HAUNTED_EYE_WOOD.get()).m_49966_();
        BlockState leaves = ((Block)AoABlocks.HAUNTED_LEAVES.get()).m_49966_();
        BlockState eyeLeaves = ((Block)AoABlocks.HAUNTED_EYES_LEAVES.get()).m_49966_();
        for (int i = 1; i <= length; ++i) {
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                BlockState logBlock = rand.m_188503_(25) == 0 ? (rand.m_188499_() ? eyeBarkLog : redEyesBarkLog) : barkLog;
                BlockPos branchLocPos = branchPos.m_5484_(dir, i);
                this.placeBlock(reader, branchPos.m_5484_(dir, i), logBlock);
                for (Direction leafDir : Direction.values()) {
                    BlockState leafBlock;
                    BlockState blockState = leafBlock = rand.m_188503_(80) == 0 ? eyeLeaves : leaves;
                    if (leafDir == Direction.DOWN) continue;
                    this.placeBlock(reader, branchLocPos.m_121945_(leafDir), leafBlock);
                }
            }
        }
    }

    private BlockState getBarkForLog(BlockState state) {
        if (state.m_60734_() == AoABlocks.HAUNTED_LOG.get()) {
            return ((Block)AoABlocks.HAUNTED_WOOD.get()).m_49966_();
        }
        if (state.m_60734_() == AoABlocks.HAUNTED_PURPLING_LOG.get()) {
            return ((Block)AoABlocks.HAUNTED_PURPLING_WOOD.get()).m_49966_();
        }
        if (state.m_60734_() == AoABlocks.HAUNTED_EYE_LOG.get()) {
            return ((Block)AoABlocks.HAUNTED_EYES_LOG.get()).m_49966_();
        }
        if (state.m_60734_() == AoABlocks.HAUNTED_EYES_LOG.get()) {
            return ((Block)AoABlocks.HAUNTED_EYES_WOOD.get()).m_49966_();
        }
        return ((Block)AoABlocks.HAUNTED_WOOD.get()).m_49966_();
    }
}

