/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.world.genold.feature.features.trees;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraftforge.common.IPlantable;
import net.tslat.aoa3.content.block.functional.plant.SaplingBlock;
import net.tslat.aoa3.content.world.genold.feature.placement.config.BlockStatePlacementConfig;
import org.apache.commons.lang3.tuple.Triple;

public abstract class AoATreeFeature
extends Feature<BlockStatePlacementConfig> {
    protected final Supplier<SaplingBlock> sapling;

    public AoATreeFeature(Codec<BlockStatePlacementConfig> codec, Supplier<SaplingBlock> sapling) {
        super(codec);
        this.sapling = sapling;
    }

    public boolean generate(ServerLevel world, RandomSource rand, BlockPos pos) {
        return this.generateTree((WorldGenLevel)world, rand, pos, false);
    }

    public boolean m_142674_(FeaturePlaceContext<BlockStatePlacementConfig> pContext) {
        return false;
    }

    public boolean place(BlockStatePlacementConfig config, WorldGenLevel level, ChunkGenerator chunkGen, RandomSource rand, BlockPos pos) {
        return this.generateTree(level, rand, pos, true);
    }

    protected abstract boolean generateTree(WorldGenLevel var1, RandomSource var2, BlockPos var3, boolean var4);

    protected void placeBlock(WorldGenLevel reader, BlockPos pos, BlockState state, boolean overwriteBlocks) {
        if (!overwriteBlocks && !AoATreeFeature.isSafeBlock(reader, pos)) {
            return;
        }
        reader.m_7731_(pos, state, 19);
    }

    protected void placeBlock(WorldGenLevel reader, BlockPos pos, BlockState state) {
        this.placeBlock(reader, pos, state, false);
    }

    protected static boolean isSafeBlock(WorldGenLevel reader, BlockPos pos) {
        BlockState existingState = reader.m_8055_(pos);
        return existingState.m_60795_() || existingState.m_60767_().m_76336_() || existingState.m_204336_(BlockTags.f_13035_);
    }

    protected boolean checkSafeHeight(WorldGenLevel reader, BlockPos pos, int maxHeight, int trunkWidth, boolean isWorldGen) {
        if (pos.m_123342_() >= 1 && pos.m_123342_() + maxHeight < 256) {
            if (isWorldGen) {
                return true;
            }
            for (int i = 1; i <= maxHeight; ++i) {
                for (int x = 0; x < trunkWidth; ++x) {
                    for (int z = 0; z < trunkWidth; ++z) {
                        if (AoATreeFeature.isSafeBlock(reader, pos.m_7918_(x, i, z))) continue;
                        return false;
                    }
                }
            }
            return true;
        }
        return false;
    }

    protected boolean checkAndPrepSoil(WorldGenLevel reader, BlockPos pos, int trunkWidth, boolean isWorldGen) {
        if (isWorldGen) {
            return true;
        }
        ArrayList<Triple> soils = new ArrayList<Triple>(trunkWidth * trunkWidth);
        for (int x = 0; x < trunkWidth; ++x) {
            for (int z = 0; z < trunkWidth; ++z) {
                BlockPos soilPos = pos.m_7918_(x, -1, z);
                BlockState soilState = reader.m_8055_(soilPos);
                Block soil = soilState.m_60734_();
                if (soilState.m_60795_() || !soil.canSustainPlant(soilState, (BlockGetter)reader, soilPos, Direction.UP, (IPlantable)this.sapling.get())) {
                    return false;
                }
                soils.add(Triple.of((Object)soilState, (Object)soil, (Object)soilPos));
            }
        }
        for (Triple soil : soils) {
            reader.m_7731_(((BlockPos)soil.getRight()).m_7494_(), Blocks.f_50016_.m_49966_(), 2);
        }
        return true;
    }

    @Nullable
    protected BlockPos findMultiSaplingPosition(WorldGenLevel reader, RandomSource rand, BlockPos pos, int size, boolean isWorldGen) {
        if (isWorldGen) {
            return pos;
        }
        for (int x = 0; x >= -(size - 1); --x) {
            block1: for (int z = 0; z >= -(size - 1); --z) {
                BlockPos checkPos = pos;
                for (int i = 0; i < size; ++i) {
                    for (int j = 0; j < size; ++j) {
                        checkPos = pos.m_7918_(x + i, 0, z + j);
                        if (reader.m_8055_(checkPos).m_60734_() != this.sapling.get()) continue block1;
                    }
                }
                return checkPos.m_7918_(-size + 1, 0, -size + 1);
            }
        }
        return null;
    }
}

