/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.world.gen.structure.special;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.tslat.aoa3.common.registration.worldgen.AoAStructureTypes;
import net.tslat.aoa3.content.world.gen.structure.AoAJigsawAssembler;
import net.tslat.aoa3.content.world.gen.structure.AoAStructure;
import net.tslat.aoa3.content.world.gen.structure.TopAlignedStructure;

public class NethengeicPit
extends TopAlignedStructure {
    public static final Codec<NethengeicPit> CODEC = RecordCodecBuilder.mapCodec(codec -> codec.group(AoAStructure.Settings.aoaSettings()).apply((Applicative)codec, NethengeicPit::new)).codec();

    public NethengeicPit(AoAStructure.Settings settings) {
        super(settings);
    }

    @Override
    public StructureType<? extends AoAStructure> m_213658_() {
        return (StructureType)AoAStructureTypes.NETHENGEIC_PIT.get();
    }

    @Override
    protected AoAJigsawAssembler getJigsawAssembler() {
        return new AoAJigsawAssembler(){

            @Override
            protected Optional<Structure.GenerationStub> buildGenerationStub(PoolElementStructurePiece startPiece, BoundingBox startPieceBounds, Structure.GenerationContext genContext, int startX, int startY, int startZ, int maxPieces, int maxRadius) {
                WorldgenRandom rand = genContext.f_226626_();
                for (int i = 0; i < 5; ++i) {
                    int x = rand.m_188503_(startPieceBounds.m_162399_() - startPieceBounds.m_162395_());
                    int z = rand.m_188503_(startPieceBounds.m_162401_() - startPieceBounds.m_162398_());
                    if (genContext.f_226622_().m_214184_(startX + x, startZ + z, genContext.f_226629_(), genContext.f_226624_()).m_183556_(NethengeicPit.this.nextGenHeight).m_60734_() == Blocks.f_49991_) continue;
                    return Optional.empty();
                }
                return Optional.of(new Structure.GenerationStub(this.getStartPos(startPiece, startX, startY, startZ), pieceBuilder -> {
                    ObjectArrayList pieces = new ObjectArrayList();
                    pieces.add(startPiece);
                    if (maxPieces > 0) {
                        this.addPieces(genContext.f_226624_(), maxPieces, genContext.f_226622_(), genContext.f_226625_(), genContext.f_226629_(), (RandomSource)genContext.f_226626_(), (Registry<StructureTemplatePool>)genContext.f_226621_().m_175515_(Registries.f_256948_), startPiece, (List<PoolElementStructurePiece>)pieces, Shapes.m_83113_((VoxelShape)Shapes.m_83064_((AABB)new AABB((double)(startX - maxRadius), -4000.0, (double)(startZ - maxRadius), (double)(startX + maxRadius + 1), 4000.0, (double)(startZ + maxRadius + 1))), (VoxelShape)Shapes.m_83064_((AABB)AABB.m_82321_((BoundingBox)startPieceBounds)), (BooleanOp)BooleanOp.f_82685_));
                        pieces.forEach(arg_0 -> ((StructurePiecesBuilder)pieceBuilder).m_142679_(arg_0));
                    }
                    pieceBuilder.m_192781_(NethengeicPit.this.nextGenHeight - startPieceBounds.m_162400_());
                }));
            }
        };
    }

    private boolean isInLava(Structure.GenerationContext context, Structure.GenerationStub genStub) {
        return true;
    }
}

