/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.world.gen.structure;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.tslat.aoa3.common.registration.worldgen.AoAStructureTypes;
import net.tslat.aoa3.content.world.gen.structure.AoAJigsawAssembler;
import net.tslat.aoa3.content.world.gen.structure.AoAStructure;

public class TopAlignedStructure
extends AoAStructure {
    protected int nextGenHeight = 0;
    public static final Codec<TopAlignedStructure> CODEC = RecordCodecBuilder.mapCodec(codec -> codec.group(AoAStructure.Settings.aoaSettings()).apply((Applicative)codec, TopAlignedStructure::new)).codec();

    public TopAlignedStructure(AoAStructure.Settings settings) {
        super(settings);
    }

    @Override
    public StructureType<? extends AoAStructure> m_213658_() {
        return (StructureType)AoAStructureTypes.TOP_ALIGNED.get();
    }

    @Override
    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext genContext) {
        ChunkPos chunkpos = genContext.f_226628_();
        this.nextGenHeight = this.settings.startHeight().m_213859_((RandomSource)genContext.f_226626_(), new WorldGenerationContext(genContext.f_226622_(), genContext.f_226629_()));
        BlockPos blockpos = new BlockPos(chunkpos.m_45604_(), this.nextGenHeight, chunkpos.m_45605_());
        return this.assembler.addPieces(genContext, this.settings.startPool(), this.settings.startJigsawName(), this.settings.maxPieces(), blockpos, this.settings.startHeightmap(), 128);
    }

    @Override
    protected AoAJigsawAssembler getJigsawAssembler() {
        return new AoAJigsawAssembler(){

            @Override
            protected Optional<Structure.GenerationStub> buildGenerationStub(PoolElementStructurePiece startPiece, BoundingBox startPieceBounds, Structure.GenerationContext genContext, int startX, int startY, int startZ, int maxPieces, int maxRadius) {
                return Optional.of(new Structure.GenerationStub(this.getStartPos(startPiece, startX, startY, startZ), pieceBuilder -> {
                    ObjectArrayList pieces = new ObjectArrayList();
                    pieces.add(startPiece);
                    if (maxPieces > 0) {
                        this.addPieces(genContext.f_226624_(), maxPieces, genContext.f_226622_(), genContext.f_226625_(), genContext.f_226629_(), (RandomSource)genContext.f_226626_(), (Registry<StructureTemplatePool>)genContext.f_226621_().m_175515_(Registries.f_256948_), startPiece, (List<PoolElementStructurePiece>)pieces, Shapes.m_83113_((VoxelShape)Shapes.m_83064_((AABB)new AABB((double)(startX - maxRadius), -4000.0, (double)(startZ - maxRadius), (double)(startX + maxRadius + 1), 4000.0, (double)(startZ + maxRadius + 1))), (VoxelShape)Shapes.m_83064_((AABB)AABB.m_82321_((BoundingBox)startPieceBounds)), (BooleanOp)BooleanOp.f_82685_));
                        pieces.forEach(arg_0 -> ((StructurePiecesBuilder)pieceBuilder).m_142679_(arg_0));
                    }
                    pieceBuilder.m_192781_(TopAlignedStructure.this.nextGenHeight - startPieceBounds.m_162400_());
                }));
            }
        };
    }
}

