/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.world.gen.structure;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.heightproviders.ConstantHeight;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.tslat.aoa3.common.registration.worldgen.AoAStructureTypes;
import net.tslat.aoa3.content.world.gen.structure.AoAJigsawAssembler;

public class AoAStructure
extends Structure {
    public static final Codec<AoAStructure> DEFAULT_CODEC = RecordCodecBuilder.mapCodec(codec -> codec.group(Settings.aoaSettings()).apply((Applicative)codec, AoAStructure::new)).codec();
    protected final Settings settings;
    protected final AoAJigsawAssembler assembler;

    public AoAStructure(Settings settings) {
        super(settings.toVanillaSettings());
        this.settings = settings;
        this.assembler = this.getJigsawAssembler();
    }

    protected AoAJigsawAssembler getJigsawAssembler() {
        return new AoAJigsawAssembler();
    }

    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext genContext) {
        ChunkPos chunkpos = genContext.f_226628_();
        int startHeight = this.settings.startHeight.m_213859_((RandomSource)genContext.f_226626_(), new WorldGenerationContext(genContext.f_226622_(), genContext.f_226629_()));
        BlockPos blockpos = new BlockPos(chunkpos.m_45604_(), startHeight, chunkpos.m_45605_());
        return this.assembler.addPieces(genContext, this.settings.startPool, this.settings.startJigsawName, this.settings.maxPieces, blockpos, this.settings.startHeightmap, 128);
    }

    public StructureType<? extends AoAStructure> m_213658_() {
        return (StructureType)AoAStructureTypes.AOA_DEFAULT.get();
    }

    public record Settings(HolderSet<Biome> biomes, Map<MobCategory, StructureSpawnOverride> spawnOverrides, GenerationStep.Decoration step, TerrainAdjustment terrainAdaptation, Holder<StructureTemplatePool> startPool, Optional<ResourceLocation> startJigsawName, int maxPieces, HeightProvider startHeight, Optional<Heightmap.Types> startHeightmap) {
        private static final MapCodec<Settings> CODEC = RecordCodecBuilder.mapCodec(codec -> codec.group((App)RegistryCodecs.m_206277_((ResourceKey)Registries.f_256952_).fieldOf("biomes").forGetter(Settings::biomes), (App)Codec.simpleMap((Codec)MobCategory.f_21584_, (Codec)StructureSpawnOverride.f_210042_, (Keyable)StringRepresentable.m_14357_((StringRepresentable[])MobCategory.values())).fieldOf("spawn_overrides").forGetter(Settings::spawnOverrides), (App)GenerationStep.Decoration.f_224188_.optionalFieldOf("step", (Object)GenerationStep.Decoration.SURFACE_STRUCTURES).forGetter(Settings::step), (App)TerrainAdjustment.f_226918_.optionalFieldOf("terrain_adaptation", (Object)TerrainAdjustment.NONE).forGetter(Settings::terrainAdaptation), (App)StructureTemplatePool.f_210555_.fieldOf("start_pool").forGetter(Settings::startPool), (App)ResourceLocation.f_135803_.optionalFieldOf("start_jigsaw_name").forGetter(Settings::startJigsawName), (App)Codec.intRange((int)0, (int)15).optionalFieldOf("size", (Object)15).forGetter(Settings::maxPieces), (App)HeightProvider.f_161970_.optionalFieldOf("start_height", (Object)ConstantHeight.m_161956_((VerticalAnchor)VerticalAnchor.m_158922_((int)0))).forGetter(Settings::startHeight), (App)Heightmap.Types.f_64274_.optionalFieldOf("heightmap_for_start").forGetter(Settings::startHeightmap)).apply((Applicative)codec, Settings::new));

        private Structure.StructureSettings toVanillaSettings() {
            return new Structure.StructureSettings(this.biomes, this.spawnOverrides, this.step, this.terrainAdaptation);
        }

        public static <T extends AoAStructure> RecordCodecBuilder<T, Settings> aoaSettings() {
            return CODEC.forGetter(instance -> instance.settings);
        }
    }
}

