/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.world.gen.structure;

import com.google.common.collect.Queues;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.pools.EmptyPoolElement;
import net.minecraft.world.level.levelgen.structure.pools.JigsawJunction;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.tslat.aoa3.advent.Logging;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.logging.log4j.Level;

public class AoAJigsawAssembler {
    protected boolean ignoreRotations() {
        return false;
    }

    protected BlockPos getStartPos(PoolElementStructurePiece startPiece, int x, int y, int z) {
        return new BlockPos(x, y, z);
    }

    public Optional<Structure.GenerationStub> addPieces(Structure.GenerationContext genContext, Holder<StructureTemplatePool> templatePoolHolder, Optional<ResourceLocation> startJigsawName, int maxPieces, BlockPos startPos, Optional<Heightmap.Types> heightmap, int maxRadius) {
        StructureTemplateManager templateManager = genContext.f_226625_();
        WorldgenRandom rand = genContext.f_226626_();
        Rotation rotation = this.ignoreRotations() ? Rotation.NONE : Rotation.m_221990_((RandomSource)rand);
        StructurePoolElement poolElement = ((StructureTemplatePool)templatePoolHolder.m_203334_()).m_227355_((RandomSource)rand);
        if (poolElement == EmptyPoolElement.f_210175_) {
            return Optional.empty();
        }
        Vec3i startOffset = Vec3i.f_123288_;
        if (startJigsawName.isPresent()) {
            Optional<BlockPos> startJigsawPos = this.getRandomNamedJigsaw(poolElement, startJigsawName.get(), startPos, rotation, templateManager, rand);
            if (startJigsawPos.isEmpty()) {
                Logging.logMessage(Level.ERROR, "No starting jigsaw " + startJigsawName.get() + " found in start pool " + ((ResourceKey)templatePoolHolder.m_203543_().get()).m_135782_());
                return Optional.empty();
            }
            startOffset = startJigsawPos.get().m_121996_((Vec3i)startPos);
        }
        BlockPos finalStartPos = startPos.m_121996_(startOffset);
        PoolElementStructurePiece startPiece = new PoolElementStructurePiece(templateManager, poolElement, finalStartPos, poolElement.m_210540_(), rotation, poolElement.m_214015_(templateManager, finalStartPos, rotation));
        BoundingBox startPieceBounds = startPiece.m_73547_();
        int structurePosX = (startPieceBounds.m_162395_() + startPieceBounds.m_162399_()) / 2;
        int structurePosZ = (startPieceBounds.m_162398_() + startPieceBounds.m_162401_()) / 2;
        int startY = finalStartPos.m_123342_();
        if (heightmap.isPresent()) {
            startY = startPos.m_123342_() + genContext.f_226622_().m_223221_(structurePosX, structurePosZ, heightmap.get(), genContext.f_226629_(), genContext.f_226624_());
        }
        startPiece.m_6324_(0, startY - (startPieceBounds.m_162396_() + startPiece.m_72647_()), 0);
        return this.buildGenerationStub(startPiece, startPieceBounds, genContext, structurePosX, startY + startOffset.m_123342_(), structurePosZ, maxPieces, maxRadius);
    }

    protected Optional<Structure.GenerationStub> buildGenerationStub(PoolElementStructurePiece startPiece, BoundingBox startPieceBounds, Structure.GenerationContext genContext, int startX, int startY, int startZ, int maxPieces, int maxRadius) {
        return Optional.of(new Structure.GenerationStub(this.getStartPos(startPiece, startX, startY, startZ), pieceBuilder -> {
            ObjectArrayList pieces = new ObjectArrayList();
            pieces.add(startPiece);
            if (maxPieces > 0) {
                this.addPieces(genContext.f_226624_(), maxPieces, genContext.f_226622_(), genContext.f_226625_(), genContext.f_226629_(), (RandomSource)genContext.f_226626_(), (Registry<StructureTemplatePool>)genContext.f_226621_().m_175515_(Registries.f_256948_), startPiece, (List<PoolElementStructurePiece>)pieces, Shapes.m_83113_((VoxelShape)Shapes.m_83064_((AABB)new AABB((double)(startX - maxRadius), -4000.0, (double)(startZ - maxRadius), (double)(startX + maxRadius + 1), 4000.0, (double)(startZ + maxRadius + 1))), (VoxelShape)Shapes.m_83064_((AABB)AABB.m_82321_((BoundingBox)startPieceBounds)), (BooleanOp)BooleanOp.f_82685_));
                pieces.forEach(arg_0 -> ((StructurePiecesBuilder)pieceBuilder).m_142679_(arg_0));
            }
        }));
    }

    protected Optional<BlockPos> getRandomNamedJigsaw(StructurePoolElement poolElement, ResourceLocation jigsawName, BlockPos startPos, Rotation rotation, StructureTemplateManager templateManager, WorldgenRandom rand) {
        for (StructureTemplate.StructureBlockInfo jigsawBlockInfo : poolElement.m_213638_(templateManager, startPos, rotation, (RandomSource)rand)) {
            if (!jigsawName.equals((Object)ResourceLocation.m_135820_((String)jigsawBlockInfo.f_74677_.m_128461_("name")))) continue;
            return Optional.of(jigsawBlockInfo.f_74675_);
        }
        return Optional.empty();
    }

    protected void addPieces(RandomState genState, int maxPieces, ChunkGenerator chunkGen, StructureTemplateManager templateManager, LevelHeightAccessor heightAccessor, RandomSource rand, Registry<StructureTemplatePool> templatePool, PoolElementStructurePiece parentPiece, List<PoolElementStructurePiece> childPieces, VoxelShape bounds) {
        PiecePlacer piecePlacer = new PiecePlacer(templatePool, maxPieces, chunkGen, templateManager, childPieces, rand);
        piecePlacer.placing.addLast(new PieceState(parentPiece, (MutableObject<VoxelShape>)new MutableObject((Object)bounds), 0));
        while (!piecePlacer.placing.isEmpty()) {
            PieceState pieceState = piecePlacer.placing.removeFirst();
            piecePlacer.tryPlacingChildren(pieceState.piece, pieceState.bounds, pieceState.depth, heightAccessor, genState);
        }
    }

    public boolean generateJigsaw(ServerLevel level, Holder<StructureTemplatePool> templatePool, ResourceLocation startJigsawName, int maxPieces, BlockPos startPos, boolean keepJigsaws) {
        ChunkGenerator chunkGen = level.m_7726_().m_8481_();
        StructureTemplateManager templateManager = level.m_215082_();
        StructureManager structureManager = level.m_215010_();
        RandomSource rand = level.m_213780_();
        Structure.GenerationContext genContext = new Structure.GenerationContext(level.m_9598_(), chunkGen, chunkGen.m_62218_(), level.m_7726_().m_214994_(), templateManager, level.m_7328_(), new ChunkPos(startPos), (LevelHeightAccessor)level, p_227255_ -> true);
        Optional<Structure.GenerationStub> pieceGen = this.addPieces(genContext, templatePool, Optional.of(startJigsawName), maxPieces, startPos, Optional.empty(), 128);
        if (pieceGen.isEmpty()) {
            return false;
        }
        StructurePiecesBuilder pieceBuilder = pieceGen.get().m_226677_();
        for (StructurePiece structurepiece : pieceBuilder.m_192780_().f_192741_()) {
            if (!(structurepiece instanceof PoolElementStructurePiece)) continue;
            PoolElementStructurePiece piece = (PoolElementStructurePiece)structurepiece;
            piece.m_226509_((WorldGenLevel)level, structureManager, chunkGen, rand, BoundingBox.m_71044_(), startPos, keepJigsaws);
        }
        return true;
    }

    protected static final class PiecePlacer {
        private final Registry<StructureTemplatePool> pools;
        private final int maxPieces;
        private final ChunkGenerator chunkGenerator;
        private final StructureTemplateManager structureTemplateManager;
        private final List<? super PoolElementStructurePiece> pieces;
        private final RandomSource random;
        final Deque<PieceState> placing = Queues.newArrayDeque();

        private PiecePlacer(Registry<StructureTemplatePool> templatePoolRegistry, int maxPieces, ChunkGenerator chunkGen, StructureTemplateManager templateManager, List<? super PoolElementStructurePiece> pieces, RandomSource rand) {
            this.pools = templatePoolRegistry;
            this.maxPieces = maxPieces;
            this.chunkGenerator = chunkGen;
            this.structureTemplateManager = templateManager;
            this.pieces = pieces;
            this.random = rand;
        }

        void tryPlacingChildren(PoolElementStructurePiece parentPiece, MutableObject<VoxelShape> bounds, int pieceDepth, LevelHeightAccessor heightAccessor, RandomState genState) {
            StructurePoolElement poolElement = parentPiece.m_209918_();
            StructureTemplatePool.Projection projection = poolElement.m_210539_();
            MutableObject<VoxelShape> shape = new MutableObject<VoxelShape>();
            BoundingBox parentBounds = parentPiece.m_73547_();
            int minY = parentBounds.m_162396_();
            for (StructureTemplate.StructureBlockInfo jigsawBlockInfo : poolElement.m_213638_(this.structureTemplateManager, parentPiece.m_72646_(), parentPiece.m_6830_(), this.random)) {
                MutableObject<VoxelShape> placementBounds;
                BlockPos jigsawPos = jigsawBlockInfo.f_74675_;
                BlockPos jigsawFacingPos = jigsawPos.m_121945_(JigsawBlock.m_54250_((BlockState)jigsawBlockInfo.f_74676_));
                ResourceLocation poolPath = new ResourceLocation(jigsawBlockInfo.f_74677_.m_128461_("pool"));
                Optional pool = this.pools.m_6612_(poolPath);
                if (pool.isEmpty() || ((StructureTemplatePool)pool.get()).m_210590_() == 0 && !poolPath.equals((Object)Pools.f_127186_.m_135782_())) {
                    Logging.logMessage(Level.WARN, "Empty or non-existent pool: " + poolPath);
                    return;
                }
                Holder fallback = ((StructureTemplatePool)pool.get()).m_254935_();
                StructureTemplatePool fallbackPool = (StructureTemplatePool)fallback.get();
                if (fallbackPool.m_210590_() == 0 && !fallback.m_203565_(Pools.f_127186_)) {
                    Logging.logMessage(Level.WARN, "Empty or non-existent fallback pool: " + ((ResourceKey)fallback.m_203543_().get()).m_135782_());
                    return;
                }
                if (parentBounds.m_71051_((Vec3i)jigsawFacingPos)) {
                    placementBounds = shape;
                    if (shape.getValue() == null) {
                        shape.setValue((Object)Shapes.m_83064_((AABB)AABB.m_82321_((BoundingBox)parentBounds)));
                    }
                } else {
                    placementBounds = bounds;
                }
                ObjectArrayList piecesToGen = new ObjectArrayList();
                if (pieceDepth != this.maxPieces) {
                    piecesToGen.addAll(((StructureTemplatePool)pool.get()).m_227362_(this.random));
                }
                piecesToGen.addAll(fallbackPool.m_227362_(this.random));
                this.placeChildren(jigsawBlockInfo, heightAccessor, genState, parentPiece, jigsawFacingPos, placementBounds, jigsawPos.m_123342_() - minY, projection == StructureTemplatePool.Projection.RIGID, minY, pieceDepth, projection, jigsawPos, (List<StructurePoolElement>)piecesToGen);
            }
        }

        private void placeChildren(StructureTemplate.StructureBlockInfo jigsawBlockInfo, LevelHeightAccessor heightAccessor, RandomState genState, PoolElementStructurePiece parentPiece, BlockPos jigsawFacingPos, MutableObject<VoxelShape> placementBounds, int jigsawPosDelta, boolean isRigid, int minY, int pieceDepth, StructureTemplatePool.Projection projection, BlockPos jigsawPos, List<StructurePoolElement> piecesToGen) {
            int terrainMatchDelta = -1;
            for (StructurePoolElement childPoolElement : piecesToGen) {
                if (childPoolElement == EmptyPoolElement.f_210175_) {
                    return;
                }
                for (Rotation pieceRotation : Rotation.m_221992_((RandomSource)this.random)) {
                    List childPieceJigsawBlocks = childPoolElement.m_213638_(this.structureTemplateManager, BlockPos.f_121853_, pieceRotation, this.random);
                    for (StructureTemplate.StructureBlockInfo childPieceJigsawBlock : childPieceJigsawBlocks) {
                        int childBaseY;
                        if (!JigsawBlock.m_54245_((StructureTemplate.StructureBlockInfo)jigsawBlockInfo, (StructureTemplate.StructureBlockInfo)childPieceJigsawBlock)) continue;
                        BlockPos childPieceJigsawPos = childPieceJigsawBlock.f_74675_;
                        BlockPos jigsawToPieceDelta = jigsawFacingPos.m_121996_((Vec3i)childPieceJigsawPos);
                        BoundingBox childBounds = childPoolElement.m_214015_(this.structureTemplateManager, jigsawToPieceDelta, pieceRotation);
                        StructureTemplatePool.Projection childProjection = childPoolElement.m_210539_();
                        boolean childIsRigid = childProjection == StructureTemplatePool.Projection.RIGID;
                        int childJigsawYPos = childPieceJigsawPos.m_123342_();
                        int deltaY = jigsawPosDelta - childJigsawYPos + JigsawBlock.m_54250_((BlockState)jigsawBlockInfo.f_74676_).m_122430_();
                        int placementYOffset = minY + deltaY;
                        if (!isRigid || !childIsRigid) {
                            if (terrainMatchDelta == -1) {
                                terrainMatchDelta = this.chunkGenerator.m_223221_(jigsawPos.m_123341_(), jigsawPos.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, heightAccessor, genState);
                            }
                            placementYOffset = terrainMatchDelta - childJigsawYPos;
                        }
                        int childBoundsOffset = placementYOffset - childBounds.m_162396_();
                        childBounds = childBounds.m_71045_(0, childBoundsOffset, 0);
                        BlockPos childPos = jigsawToPieceDelta.m_7918_(0, childBoundsOffset, 0);
                        if (Shapes.m_83157_((VoxelShape)((VoxelShape)placementBounds.getValue()), (VoxelShape)Shapes.m_83064_((AABB)AABB.m_82321_((BoundingBox)childBounds).m_82406_(0.25)), (BooleanOp)BooleanOp.f_82683_)) continue;
                        placementBounds.setValue((Object)Shapes.m_83148_((VoxelShape)((VoxelShape)placementBounds.getValue()), (VoxelShape)Shapes.m_83064_((AABB)AABB.m_82321_((BoundingBox)childBounds)), (BooleanOp)BooleanOp.f_82685_));
                        int parentGroundDelta = parentPiece.m_72647_();
                        int groundLevelDelta = childPoolElement.m_210540_();
                        if (childIsRigid) {
                            groundLevelDelta = parentGroundDelta - deltaY;
                        }
                        PoolElementStructurePiece childPiece = new PoolElementStructurePiece(this.structureTemplateManager, childPoolElement, childPos, groundLevelDelta, pieceRotation, childBounds);
                        if (isRigid) {
                            childBaseY = minY + jigsawPosDelta;
                        } else if (childIsRigid) {
                            childBaseY = placementYOffset + childJigsawYPos;
                        } else {
                            if (terrainMatchDelta == -1) {
                                terrainMatchDelta = this.chunkGenerator.m_223221_(jigsawPos.m_123341_(), jigsawPos.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, heightAccessor, genState);
                            }
                            childBaseY = terrainMatchDelta + deltaY / 2;
                        }
                        parentPiece.m_209916_(new JigsawJunction(jigsawFacingPos.m_123341_(), childBaseY - jigsawPosDelta + parentGroundDelta, jigsawFacingPos.m_123343_(), deltaY, childProjection));
                        childPiece.m_209916_(new JigsawJunction(jigsawPos.m_123341_(), childBaseY - childJigsawYPos + groundLevelDelta, jigsawPos.m_123343_(), -deltaY, projection));
                        this.pieces.add((PoolElementStructurePiece)childPiece);
                        if (pieceDepth + 1 <= this.maxPieces) {
                            this.placing.addLast(new PieceState(childPiece, placementBounds, pieceDepth + 1));
                        }
                        return;
                    }
                }
            }
        }
    }

    protected static final class PieceState {
        private final PoolElementStructurePiece piece;
        private final MutableObject<VoxelShape> bounds;
        private final int depth;

        PieceState(PoolElementStructurePiece piece, MutableObject<VoxelShape> bounds, int pieceDepth) {
            this.piece = piece;
            this.bounds = bounds;
            this.depth = pieceDepth;
        }
    }
}

