/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.recipe;

import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.crafting.IShapedRecipe;
import net.tslat.aoa3.common.registration.AoARecipes;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.content.block.functional.misc.TrophyBlock;

public class TrophyRecipe
implements CraftingRecipe,
IShapedRecipe<CraftingContainer> {
    public static final ResourceLocation ID = new ResourceLocation("aoa3", "trophy");
    private final String group;

    public TrophyRecipe(String group) {
        this.group = group;
    }

    public boolean matches(CraftingContainer inv, Level worldIn) {
        for (int x = 0; x <= inv.m_39347_() - 3; ++x) {
            for (int y = 0; y <= inv.m_39346_() - 3; ++y) {
                if (!this.checkMatch(inv)) continue;
                return true;
            }
        }
        return false;
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList ingredients = NonNullList.m_122779_();
        for (int i = 0; i < 9; ++i) {
            ingredients.add((Object)Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)AoABlocks.TROPHY.get())}));
        }
        return ingredients;
    }

    public String m_6076_() {
        return this.group;
    }

    public ItemStack assemble(CraftingContainer inv, RegistryAccess registryAccess) {
        for (int i = 0; i < inv.m_6643_(); ++i) {
            if (inv.m_8020_(i).m_41720_() != ((Block)AoABlocks.TROPHY.get()).m_5456_()) continue;
            return TrophyBlock.cloneTrophy(inv.m_8020_(i), (ItemLike)AoABlocks.GOLD_TROPHY.get());
        }
        return ItemStack.f_41583_;
    }

    private boolean checkMatch(CraftingContainer inv) {
        String entityType = null;
        for (int gridX = 0; gridX < inv.m_39347_(); ++gridX) {
            for (int gridY = 0; gridY < inv.m_39346_(); ++gridY) {
                ItemStack slotStack = inv.m_8020_(gridX + gridY * inv.m_39347_());
                if (slotStack.m_41720_() != ((Block)AoABlocks.TROPHY.get()).m_5456_() || !slotStack.m_41782_()) {
                    return false;
                }
                CompoundTag tag = slotStack.m_41783_();
                if (!tag.m_128441_("BlockEntityTag")) {
                    return false;
                }
                CompoundTag blockEntityTag = tag.m_128469_("BlockEntityTag");
                if (!blockEntityTag.m_128441_("OriginalTrophy") || !blockEntityTag.m_128471_("OriginalTrophy")) {
                    return false;
                }
                if (!blockEntityTag.m_128441_("EntityID")) continue;
                if (entityType == null) {
                    entityType = blockEntityTag.m_128461_("EntityID");
                    continue;
                }
                if (entityType.equals(blockEntityTag.m_128461_("EntityID"))) continue;
                return false;
            }
        }
        return true;
    }

    public boolean m_8004_(int width, int height) {
        return width >= 3 && height >= 3;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return new ItemStack((ItemLike)AoABlocks.GOLD_TROPHY.get());
    }

    public ResourceLocation m_6423_() {
        return ID;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)AoARecipes.TROPHY.serializer().get();
    }

    public RecipeType<?> m_6671_() {
        return RecipeType.f_44107_;
    }

    public CraftingBookCategory m_245232_() {
        return CraftingBookCategory.MISC;
    }

    public int getRecipeWidth() {
        return 3;
    }

    public int getRecipeHeight() {
        return 3;
    }

    public static class Factory
    implements RecipeSerializer<TrophyRecipe> {
        public TrophyRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            return new TrophyRecipe(json.has("group") ? GsonHelper.m_13906_((JsonObject)json, (String)"group") : "");
        }

        @Nullable
        public TrophyRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            return new TrophyRecipe(buffer.m_130136_(Short.MAX_VALUE));
        }

        public void toNetwork(FriendlyByteBuf buffer, TrophyRecipe recipe) {
            buffer.m_130070_(recipe.m_6076_());
        }
    }
}

