/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.loottable.modifier;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;

public class ReplaceItemsLootModifier
extends LootModifier {
    public static final Codec<ReplaceItemsLootModifier> CODEC = RecordCodecBuilder.create(builder -> ReplaceItemsLootModifier.codecStart((RecordCodecBuilder.Instance)builder).and((App)Codec.pair((Codec)ForgeRegistries.ITEMS.getCodec().fieldOf("item").codec(), (Codec)ItemStack.f_41582_.fieldOf("replace_with").codec()).listOf().fieldOf("replacements").forGetter(instance -> instance.replacements)).apply((Applicative)builder, ReplaceItemsLootModifier::new));
    private final List<Pair<Item, ItemStack>> replacements;

    public ReplaceItemsLootModifier(LootItemCondition[] conditions, List<Pair<Item, ItemStack>> replacements) {
        super(conditions);
        this.replacements = replacements;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }

    @Nonnull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        ObjectArrayList loot = new ObjectArrayList();
        for (ItemStack stack : generatedLoot) {
            for (Pair<Item, ItemStack> pair : this.replacements) {
                loot.add((Object)(stack.m_150930_((Item)pair.getFirst()) ? (ItemStack)pair.getSecond() : stack));
            }
        }
        EquipmentSlot[] equipmentSlotArray = context.m_78953_(LootContextParams.f_81455_);
        if (equipmentSlotArray instanceof Mob) {
            Mob mob = (Mob)equipmentSlotArray;
            block2: for (EquipmentSlot slot : EquipmentSlot.values()) {
                ItemStack stack = mob.m_6844_(slot);
                if (stack.m_41619_()) continue;
                for (Pair<Item, ItemStack> pair : this.replacements) {
                    if (!stack.m_150930_((Item)pair.getFirst())) continue;
                    mob.m_8061_(slot, (ItemStack)pair.getSecond());
                    continue block2;
                }
            }
        }
        return loot;
    }
}

