/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.loottable.entrytype;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryType;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.tslat.aoa3.common.registration.AoALootOperations;

public class CollectionLootEntry
extends LootPoolSingletonContainer {
    private final LootPoolEntryContainer[] entries;

    CollectionLootEntry(LootPoolEntryContainer[] entries, int weight, int quality, LootItemCondition[] conditions, LootItemFunction[] functions) {
        super(weight, quality, conditions, functions);
        this.entries = entries;
    }

    public LootPoolEntryType m_6751_() {
        return (LootPoolEntryType)AoALootOperations.LootEntryTypes.COLLECTION.get();
    }

    protected void m_6948_(Consumer<ItemStack> loot, LootContext context) {
        for (LootPoolEntryContainer entry : this.entries) {
            entry.m_6562_(context, subEntry -> subEntry.m_6941_(loot, context));
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends LootPoolEntryContainer.Builder<Builder> {
        private final List<LootPoolEntryContainer> entries = new ObjectArrayList();

        private Builder() {
        }

        protected Builder getThis() {
            return this;
        }

        public Builder with(LootPoolEntryContainer.Builder<?> ... childBuilders) {
            for (LootPoolEntryContainer.Builder<?> builder : childBuilders) {
                this.entries.add(builder.m_7512_());
            }
            return this;
        }

        public LootPoolEntryContainer m_7512_() {
            return LootPoolSingletonContainer.m_79687_((weight, quality, conditions, functions) -> new CollectionLootEntry(this.entries.toArray(new LootPoolEntryContainer[0]), weight, quality, conditions, functions)).m_7512_();
        }
    }

    public static class Serializer
    extends LootPoolSingletonContainer.Serializer<CollectionLootEntry> {
        public void serializeCustom(JsonObject json, CollectionLootEntry entry, JsonSerializationContext context) {
            super.m_7219_(json, (LootPoolSingletonContainer)entry, context);
            JsonArray children = new JsonArray();
            for (LootPoolEntryContainer subEntry : entry.entries) {
                JsonObject childObj = new JsonObject();
                childObj.addProperty("type", BuiltInRegistries.f_257035_.m_7981_((Object)subEntry.m_6751_()).toString());
                ((LootPoolEntryContainer.Serializer)subEntry.m_6751_().m_79331_()).m_6170_(childObj, subEntry, context);
                children.add((JsonElement)childObj);
            }
            json.add("children", (JsonElement)children);
        }

        protected CollectionLootEntry deserialize(JsonObject json, JsonDeserializationContext context, int weight, int quality, LootItemCondition[] conditions, LootItemFunction[] functions) {
            JsonArray children = json.getAsJsonArray("children");
            ObjectArrayList entries = new ObjectArrayList();
            for (JsonElement child : children) {
                JsonObject obj = child.getAsJsonObject();
                ResourceLocation type = new ResourceLocation(GsonHelper.m_13906_((JsonObject)obj, (String)"type"));
                entries.add((LootPoolEntryContainer)((LootPoolEntryType)BuiltInRegistries.f_257035_.m_7745_(type)).m_79331_().m_7561_(obj, context));
            }
            return new CollectionLootEntry(entries.toArray(new LootPoolEntryContainer[0]), weight, quality, conditions, functions);
        }
    }
}

