/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.loottable.condition;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.tslat.aoa3.common.registration.AoALootOperations;
import net.tslat.aoa3.common.registration.AoARegistries;
import net.tslat.aoa3.common.registration.custom.AoASkills;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.util.PlayerUtil;

public class PlayerHasLevel
implements LootItemCondition {
    private final AoASkill skill;
    private final int level;

    public PlayerHasLevel(AoASkill skill, int level) {
        this.skill = skill;
        this.level = level;
    }

    public LootItemConditionType m_7940_() {
        return (LootItemConditionType)AoALootOperations.LootConditions.PLAYER_HAS_LEVEL.get();
    }

    public boolean test(LootContext lootContext) {
        Entity entity = (Entity)lootContext.m_78953_(LootContextParams.f_81458_);
        if (entity == null) {
            entity = (Entity)lootContext.m_78953_(LootContextParams.f_81455_);
        }
        return entity instanceof ServerPlayer && PlayerUtil.doesPlayerHaveLevel((Player)((ServerPlayer)entity), this.skill, this.level);
    }

    public AoASkill getSkill() {
        return this.skill;
    }

    public int getLevel() {
        return this.level;
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<PlayerHasLevel> {
        public void serialize(JsonObject json, PlayerHasLevel playerHasLevel, JsonSerializationContext jsonSerializationContext) {
            json.addProperty("skill", AoARegistries.AOA_SKILLS.getId(playerHasLevel.skill).toString());
            json.addProperty("level", (Number)playerHasLevel.level);
        }

        public PlayerHasLevel deserialize(JsonObject json, JsonDeserializationContext jsonDeserializationContext) {
            return new PlayerHasLevel(AoASkills.getSkill(new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"skill"))), GsonHelper.m_13927_((JsonObject)json, (String)"level"));
        }
    }
}

