/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.loottable.condition;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.tslat.aoa3.common.registration.AoALootOperations;

public class HoldingItem
implements LootItemCondition {
    private final LootContext.EntityTarget target;
    private final ItemPredicate predicate;
    @Nullable
    private final InteractionHand hand;

    public HoldingItem(LootContext.EntityTarget target, ItemPredicate predicate, @Nullable InteractionHand hand) {
        this.target = target;
        this.predicate = predicate;
        this.hand = hand;
    }

    public boolean test(LootContext lootContext) {
        Entity entity = (Entity)lootContext.m_78953_(this.target.m_79003_());
        if (entity instanceof LivingEntity) {
            if (this.hand != null) {
                return this.predicate.m_45049_(((LivingEntity)entity).m_21120_(this.hand));
            }
            for (ItemStack stack : entity.m_6167_()) {
                if (!this.predicate.m_45049_(stack)) continue;
                return true;
            }
        }
        return false;
    }

    public LootItemConditionType m_7940_() {
        return (LootItemConditionType)AoALootOperations.LootConditions.HOLDING_ITEM.get();
    }

    public LootContext.EntityTarget getTarget() {
        return this.target;
    }

    public ItemPredicate getPredicate() {
        return this.predicate;
    }

    @Nullable
    public InteractionHand getHand() {
        return this.hand;
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<HoldingItem> {
        public void serialize(JsonObject json, HoldingItem holdingItem, JsonSerializationContext jsonSerializationContext) {
            json.add("target", jsonSerializationContext.serialize((Object)holdingItem.target));
            json.add("predicate", holdingItem.predicate.m_45048_());
            if (holdingItem.hand != null) {
                json.addProperty("hand", holdingItem.hand.toString().toLowerCase());
            }
        }

        public HoldingItem deserialize(JsonObject json, JsonDeserializationContext jsonDeserializationContext) {
            return new HoldingItem((LootContext.EntityTarget)GsonHelper.m_13836_((JsonObject)json, (String)"target", (JsonDeserializationContext)jsonDeserializationContext, LootContext.EntityTarget.class), ItemPredicate.m_45051_((JsonElement)json.get("predicate")), json.has("hand") ? InteractionHand.valueOf((String)json.get("hand").getAsString().toUpperCase()) : null);
        }
    }
}

