/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.vulcane;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.custom.AoAResources;
import net.tslat.aoa3.player.resource.AoAResource;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.PlayerUtil;

public abstract class BaseVulcane
extends Item {
    protected double baseDmg;

    public BaseVulcane(double dmg, int durability) {
        super(new Item.Properties().m_41503_(durability));
        this.baseDmg = dmg;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public double getDamage() {
        return this.baseDmg;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!(player instanceof ServerPlayer)) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        AoAResource.Instance rage = PlayerUtil.getResource(player, (AoAResource)AoAResources.RAGE.get());
        if (!rage.hasAmount(50.0f) || player.m_21188_() == null) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        return this.activate(rage, stack, hand);
    }

    public InteractionResultHolder<ItemStack> activate(AoAResource.Instance rage, ItemStack vulcane, InteractionHand hand) {
        ServerPlayer pl = rage.getPlayerDataManager().player();
        float targetHealth = pl.m_21188_().m_21223_();
        float damage = (float)this.getDamage() * (1.0f + (rage.getCurrentValue() - 50.0f) / 100.0f);
        if (DamageUtil.doVulcaneAttack((Entity)pl, (Entity)pl.m_21188_(), damage)) {
            this.doAdditionalEffect(pl.m_21188_(), (Player)pl, Math.min(targetHealth, damage));
            pl.f_19853_.m_6263_(null, pl.m_20185_(), pl.m_20186_(), pl.m_20189_(), (SoundEvent)AoASounds.ITEM_VULCANE_USE.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            ItemUtil.damageItem(vulcane, (LivingEntity)pl, hand);
            rage.consume(rage.getCurrentValue(), true);
            return InteractionResultHolder.m_19090_((Object)vulcane);
        }
        return InteractionResultHolder.m_19100_((Object)vulcane);
    }

    public void doAdditionalEffect(LivingEntity target, Player player, float damageDealt) {
    }

    public int m_6473_() {
        return 8;
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(1, (Component)LocaleUtil.getFormattedItemDescriptionText("items.description.damage.vulcane", LocaleUtil.ItemDescriptionType.ITEM_DAMAGE, new Component[]{LocaleUtil.numToComponent(this.baseDmg)}));
        tooltip.add((Component)LocaleUtil.getFormattedItemDescriptionText("items.description.vulcane.use", LocaleUtil.ItemDescriptionType.ITEM_TYPE_INFO, new Component[0]));
        tooltip.add((Component)LocaleUtil.getFormattedItemDescriptionText("items.description.vulcane.target", LocaleUtil.ItemDescriptionType.ITEM_TYPE_INFO, new Component[0]));
    }
}

