/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.thrown;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.content.entity.projectile.gun.BaseBullet;
import net.tslat.aoa3.content.item.weapon.gun.BaseGun;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.NumberUtil;

public abstract class BaseThrownWeapon
extends BaseGun {
    double dmg;
    int firingDelay;

    public BaseThrownWeapon(float dmg, int fireDelayTicks) {
        super(new Item.Properties().m_41487_(64), dmg, fireDelayTicks, 0.0f);
        this.dmg = dmg;
        this.firingDelay = fireDelayTicks;
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    @Override
    public boolean isFullAutomatic() {
        return false;
    }

    @Override
    public Item getAmmoItem() {
        return this;
    }

    @Override
    public float getRecoilForShot(ItemStack stack, LivingEntity shooter) {
        return 0.0f;
    }

    @Override
    @Nullable
    public SoundEvent getFiringSound() {
        return SoundEvents.f_12437_;
    }

    @Override
    public void doImpactDamage(Entity target, LivingEntity shooter, BaseBullet bullet, Vec3 impactPosition, float bulletDmgMultiplier) {
    }

    @Override
    public BaseBullet findAndConsumeAmmo(LivingEntity shooter, ItemStack weaponStack, InteractionHand hand) {
        if (weaponStack.m_41619_()) {
            return null;
        }
        if (!shooter.f_19853_.m_5776_() && shooter instanceof Player && !((Player)shooter).m_7500_()) {
            weaponStack.m_41774_(1);
        }
        return this.createProjectileEntity(shooter, weaponStack, hand);
    }

    @Override
    protected void doFiringEffects(LivingEntity shooter, BaseBullet bullet, ItemStack stack, InteractionHand hand) {
        this.doFiringSound(shooter, bullet, stack, hand);
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        if (this.dmg > 0.0) {
            tooltip.add(1, (Component)LocaleUtil.getFormattedItemDescriptionText("items.description.damage.ranged", LocaleUtil.ItemDescriptionType.ITEM_DAMAGE, new Component[]{LocaleUtil.numToComponent(this.dmg)}));
        }
        tooltip.add((Component)LocaleUtil.getFormattedItemDescriptionText("items.description.thrownWeapon", LocaleUtil.ItemDescriptionType.ITEM_TYPE_INFO, new Component[0]));
        tooltip.add((Component)LocaleUtil.getFormattedItemDescriptionText("items.description.throwable.speed", LocaleUtil.ItemDescriptionType.NEUTRAL, new Component[]{Component.m_237113_((String)NumberUtil.roundToNthDecimalPlace(20.0f / (float)this.firingDelay, 2))}));
    }

    @Override
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot equipmentSlot, ItemStack stack) {
        return HashMultimap.create();
    }
}

