/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.sword;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.tslat.aoa3.common.registration.AoATags;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.common.registration.item.AoATiers;
import net.tslat.aoa3.content.item.weapon.sword.BaseSword;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.smartbrainlib.util.RandomUtil;

public class RunicSword
extends BaseSword {
    public RunicSword() {
        super(AoATiers.RUNIC);
    }

    @Override
    public float getDamageForAttack(LivingEntity target, LivingEntity attacker, ItemStack swordStack, float baseDamage) {
        ItemStack offhandStack;
        if (baseDamage / this.m_43299_() > 0.75f && (offhandStack = attacker.m_21206_()).m_41720_() == AoAItems.FIRE_RUNE.get() && offhandStack.m_41613_() >= 5) {
            target.m_20254_(5);
        }
        return super.getDamageForAttack(target, attacker, swordStack, baseDamage);
    }

    @Override
    protected void doMeleeEffect(ItemStack stack, LivingEntity target, LivingEntity attacker, float attackCooldown) {
        ItemStack offhandStack;
        if (!attacker.f_19853_.f_46443_ && (double)attackCooldown > 0.75 && (offhandStack = attacker.m_21206_()).m_204117_(AoATags.Items.ADVENT_RUNE) && offhandStack.m_41613_() >= 5) {
            Item rune = offhandStack.m_41720_();
            if (rune == AoAItems.POISON_RUNE.get()) {
                target.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 72, 1, false, true));
            } else if (rune == AoAItems.WITHER_RUNE.get()) {
                target.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 40, 2, false, true));
            } else if (rune == AoAItems.WIND_RUNE.get()) {
                DamageUtil.doScaledKnockback(target, attacker, 0.5f, 1.0, 1.0, 1.0);
            } else if (rune == AoAItems.WATER_RUNE.get()) {
                target.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 60, 0, false, true));
            } else if (rune == AoAItems.CHARGED_RUNE.get()) {
                ((ServerLevel)target.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123792_, target.m_20185_() + (double)(RandomUtil.randomValueUpTo((float)1.0f) * target.m_20205_() * 2.0f) - (double)target.m_20205_(), target.m_20186_() + 1.0 + (double)(RandomUtil.randomValueUpTo((float)1.0f) * target.m_20206_()), target.m_20189_() + (double)(RandomUtil.randomValueUpTo((float)1.0f) * target.m_20205_() * 2.0f) - (double)target.m_20205_(), 3, 0.0, 0.0, 0.0, 0.0);
            } else if (rune != AoAItems.FIRE_RUNE.get()) {
                return;
            }
            if (attacker instanceof Player) {
                Player pl = (Player)attacker;
                if (!pl.m_150110_().f_35937_) {
                    offhandStack.m_41774_(5);
                    ItemUtil.damageItem(stack, attacker, 1, EquipmentSlot.MAINHAND);
                }
            }
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText((Item)this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new Component[0]));
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText((Item)this, LocaleUtil.ItemDescriptionType.HARMFUL, 2, new Component[0]));
    }
}

