/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.staff;

import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.common.registration.worldgen.AoADimensions;
import net.tslat.aoa3.content.entity.projectile.staff.BaseEnergyShot;
import net.tslat.aoa3.content.entity.projectile.staff.ShyreShotEntity;
import net.tslat.aoa3.content.item.weapon.staff.BaseStaff;
import net.tslat.aoa3.event.custom.AoAEvents;
import net.tslat.aoa3.event.custom.events.MagicTeleportEvent;
import net.tslat.aoa3.util.AdvancementUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.WorldUtil;

public class ShyreStaff
extends BaseStaff<Object> {
    public ShyreStaff(int durability) {
        super(durability);
    }

    @Override
    @Nullable
    public SoundEvent getCastingSound() {
        return (SoundEvent)AoASounds.ITEM_SHYRE_STAFF_CAST.get();
    }

    @Override
    protected void populateRunes(HashMap<Item, Integer> runes) {
        runes.put((Item)AoAItems.ENERGY_RUNE.get(), 3);
        runes.put((Item)AoAItems.DISTORTION_RUNE.get(), 3);
    }

    @Override
    public void cast(Level world, ItemStack staff, LivingEntity caster, Object args) {
        world.m_7967_((Entity)new ShyreShotEntity(caster, this, 120));
    }

    @Override
    public void doBlockImpact(BaseEnergyShot shot, Vec3 hitPos, LivingEntity shooter) {
        Level world = shooter.f_19853_;
        BlockPos.MutableBlockPos testPos = new BlockPos.MutableBlockPos(hitPos.m_7096_(), hitPos.m_7098_(), hitPos.m_7094_());
        BlockState state = world.m_8055_((BlockPos)testPos);
        Vec3 shotMotion = shot.m_20184_();
        Vec3 testVec = hitPos;
        for (int tests = 0; tests <= 10 && !(state = world.m_8055_((BlockPos)testPos)).m_60795_(); ++tests) {
            testVec = testVec.m_82492_(shotMotion.m_7096_() * (double)0.15f, shotMotion.m_7098_() * (double)0.15f, shotMotion.m_7094_() * (double)0.15f);
            testPos.m_122169_(testVec.m_7096_() + (double)shooter.m_20205_(), testVec.m_7098_(), testVec.m_7094_() + (double)shooter.m_20205_());
        }
        if (state.m_60795_()) {
            MagicTeleportEvent event = AoAEvents.magicalTeleport((Entity)shooter, null, null, testVec);
            if (event.isCanceled()) {
                return;
            }
            testVec = event.getTarget();
        }
        shooter.m_6021_(testVec.m_7096_(), testVec.m_7098_(), testVec.m_7094_());
        if (shooter instanceof ServerPlayer && WorldUtil.isWorld(shooter.f_19853_, AoADimensions.LUNALUS.key)) {
            AdvancementUtil.completeAdvancement((ServerPlayer)shooter, new ResourceLocation("aoa3", "lunalus/200_iq"), "lunalus_shyre_staff_travel");
        }
    }

    @Override
    public boolean doEntityImpact(BaseEnergyShot shot, Entity target, LivingEntity shooter) {
        MagicTeleportEvent event = AoAEvents.magicalTeleport((Entity)shooter, null, null, new Vec3((target.m_20185_() + shot.m_20185_()) / 2.0, (target.m_20186_() + shot.m_20186_()) / 2.0, (target.m_20189_() + shot.m_20189_()) / 2.0));
        if (event.isCanceled()) {
            return false;
        }
        shooter.m_6021_(event.getTargetX(), event.getTargetY(), event.getTargetZ());
        return true;
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new Component[0]));
        super.m_7373_(stack, world, tooltip, flag);
    }
}

