/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.staff;

import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.content.entity.projectile.staff.BaseEnergyShot;
import net.tslat.aoa3.content.entity.projectile.staff.MoonlightFallEntity;
import net.tslat.aoa3.content.item.weapon.staff.BaseStaff;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.PlayerUtil;

public class MoonlightStaff
extends BaseStaff<BlockPos> {
    public MoonlightStaff(int durability) {
        super(durability);
    }

    @Override
    @Nullable
    public SoundEvent getCastingSound() {
        return (SoundEvent)AoASounds.ITEM_MOONLIGHT_STAFF_CAST.get();
    }

    @Override
    protected void populateRunes(HashMap<Item, Integer> runes) {
        runes.put((Item)AoAItems.COMPASS_RUNE.get(), 1);
        runes.put((Item)AoAItems.LUNAR_RUNE.get(), 2);
        runes.put((Item)AoAItems.KINETIC_RUNE.get(), 2);
    }

    @Override
    public BlockPos checkPreconditions(LivingEntity caster, ItemStack staff) {
        BlockPos trace = null;
        if (caster instanceof Player) {
            trace = PlayerUtil.getBlockAimingAt((Player)caster, 70.0);
        }
        return trace;
    }

    @Override
    public void cast(Level world, ItemStack staff, LivingEntity caster, BlockPos args) {
        world.m_7967_((Entity)new MoonlightFallEntity(caster, this, args.m_123341_(), args.m_123342_() + 30, args.m_123343_(), 3.0f));
    }

    @Override
    public void doBlockImpact(BaseEnergyShot shot, Vec3 hitPos, LivingEntity caster) {
        this.createCloud(shot, caster);
    }

    @Override
    public boolean doEntityImpact(BaseEnergyShot shot, Entity target, LivingEntity caster) {
        if (!target.m_20147_()) {
            this.createCloud(shot, caster);
            return true;
        }
        return false;
    }

    private void createCloud(BaseEnergyShot shot, LivingEntity caster) {
        AreaEffectCloud cloud = new AreaEffectCloud(shot.f_19853_, shot.m_20185_(), shot.m_20186_(), shot.m_20189_());
        cloud.m_19718_(caster);
        cloud.m_19716_(new MobEffectInstance(MobEffects.f_19597_, 140, 1, false, true));
        cloud.m_19712_(0.1f);
        cloud.m_19738_(1.0f);
        cloud.m_19734_(10);
        cloud.m_19740_(0);
        shot.f_19853_.m_7967_((Entity)cloud);
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new Component[0]));
        super.m_7373_(stack, world, tooltip, flag);
    }
}

