/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.staff;

import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.content.entity.projectile.staff.BaseEnergyShot;
import net.tslat.aoa3.content.entity.projectile.staff.LyonicShotEntity;
import net.tslat.aoa3.content.item.weapon.staff.BaseStaff;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.WorldUtil;
import net.tslat.effectslib.api.util.EffectBuilder;
import net.tslat.smartbrainlib.util.RandomUtil;

public class LyonicStaff
extends BaseStaff<List<LivingEntity>> {
    public LyonicStaff(int durability) {
        super(durability);
    }

    @Override
    @Nullable
    public SoundEvent getCastingSound() {
        return (SoundEvent)AoASounds.ITEM_STAFF_CAST.get();
    }

    @Override
    protected void populateRunes(HashMap<Item, Integer> runes) {
        runes.put((Item)AoAItems.ENERGY_RUNE.get(), 1);
        runes.put((Item)AoAItems.WIND_RUNE.get(), 1);
        runes.put((Item)AoAItems.WITHER_RUNE.get(), 2);
        runes.put((Item)AoAItems.STRIKE_RUNE.get(), 1);
    }

    @Override
    @Nullable
    public List<LivingEntity> checkPreconditions(LivingEntity caster, ItemStack staff) {
        List targets = caster.f_19853_.m_6443_(LivingEntity.class, caster.m_20191_().m_82377_(10.0, 1.0, 10.0), entity -> entity instanceof Enemy && entity.m_6084_());
        return targets.isEmpty() ? null : targets;
    }

    @Override
    public void cast(Level world, ItemStack staff, LivingEntity caster, List<LivingEntity> args) {
        for (float x = -1.0f; x <= 1.0f; x += 0.125f) {
            for (float z = -1.0f; z <= 1.0f; z += 0.125f) {
                world.m_7967_((Entity)new LyonicShotEntity(caster, this, 1, x, 0.0f, z));
            }
        }
    }

    @Override
    public boolean doEntityImpact(BaseEnergyShot shot, Entity target, LivingEntity shooter) {
        if (EntityUtil.isHostileMob(target) && target.f_19853_ instanceof ServerLevel) {
            EntityUtil.applyPotions(target, new EffectBuilder(MobEffects.f_19615_, 100).level(2));
            if (RandomUtil.oneInNChance((int)150)) {
                WorldUtil.spawnLightning((ServerLevel)target.f_19853_, shooter instanceof ServerPlayer ? (ServerPlayer)shooter : null, target.m_20185_(), target.m_20186_(), target.m_20189_(), true, false);
            }
            return true;
        }
        return false;
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new Component[0]));
        tooltip.add((Component)LocaleUtil.getFormattedItemDescriptionText("items.description.damage.wither", LocaleUtil.ItemDescriptionType.BENEFICIAL, new Component[0]));
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 2, new Component[0]));
        super.m_7373_(stack, world, tooltip, flag);
    }
}

