/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.staff;

import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.content.item.weapon.staff.BaseStaff;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.effectslib.api.util.EffectBuilder;
import net.tslat.smartbrainlib.util.EntityRetrievalUtil;

public class JokerStaff
extends BaseStaff<List<LivingEntity>> {
    public JokerStaff(int durability) {
        super(durability);
    }

    @Override
    @Nullable
    public SoundEvent getCastingSound() {
        return (SoundEvent)AoASounds.ITEM_JOKER_STAFF_CAST.get();
    }

    @Override
    protected void populateRunes(HashMap<Item, Integer> runes) {
        runes.put((Item)AoAItems.WIND_RUNE.get(), 4);
        runes.put((Item)AoAItems.KINETIC_RUNE.get(), 4);
    }

    @Override
    public List<LivingEntity> checkPreconditions(LivingEntity caster, ItemStack staff) {
        List list = EntityRetrievalUtil.getEntities((Entity)caster, (double)10.0, entity -> {
            if (!(entity instanceof LivingEntity)) return false;
            LivingEntity livingEntity = (LivingEntity)entity;
            if (!(entity instanceof Enemy)) return false;
            if (EntityUtil.isImmuneToSpecialAttacks((Entity)livingEntity, caster)) return false;
            return true;
        });
        if (!list.isEmpty()) {
            return list;
        }
        return null;
    }

    @Override
    public void cast(Level world, ItemStack staff, LivingEntity caster, List<LivingEntity> args) {
        EntityUtil.applyPotions(args, new EffectBuilder(MobEffects.f_19620_, 100).level(6), new EffectBuilder(MobEffects.f_19603_, 140).level(21));
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new Component[0]));
        tooltip.add((Component)LocaleUtil.getFormattedItemDescriptionText("items.description.damage.specImmune", LocaleUtil.ItemDescriptionType.NEUTRAL, new Component[0]));
        super.m_7373_(stack, world, tooltip, flag);
    }
}

