/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.staff;

import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.content.item.weapon.staff.BaseStaff;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.WorldUtil;
import net.tslat.effectslib.api.util.EffectBuilder;

public class ConcussionStaff
extends BaseStaff<List<LivingEntity>> {
    public ConcussionStaff(int durability) {
        super(durability);
    }

    @Override
    @Nullable
    public SoundEvent getCastingSound() {
        return (SoundEvent)AoASounds.ITEM_CONCUSSION_STAFF_CAST.get();
    }

    @Override
    public List<LivingEntity> checkPreconditions(LivingEntity caster, ItemStack staff) {
        List list = caster.f_19853_.m_6443_(LivingEntity.class, caster.m_20191_().m_82400_(8.0), EntityUtil.Predicates.HOSTILE_MOB);
        if (!list.isEmpty()) {
            return list;
        }
        return null;
    }

    @Override
    protected void populateRunes(HashMap<Item, Integer> runes) {
        runes.put((Item)AoAItems.POWER_RUNE.get(), 4);
        runes.put((Item)AoAItems.STORM_RUNE.get(), 4);
    }

    @Override
    public void cast(Level world, ItemStack staff, LivingEntity caster, List<LivingEntity> args) {
        for (LivingEntity e : args) {
            EntityUtil.pushEntityAway((Entity)caster, (Entity)e, 3.0f);
            WorldUtil.createExplosion((Entity)caster, e.f_19853_, e.m_20185_(), e.m_20186_() + (double)e.m_20206_() + 0.5, e.m_20189_(), 2.3f);
            EntityUtil.applyPotions((Entity)e, new EffectBuilder(MobEffects.f_19597_, 25).level(10));
        }
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new Component[0]));
        super.m_7373_(stack, world, tooltip, flag);
    }
}

