/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.sniper;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.content.entity.projectile.gun.BaseBullet;
import net.tslat.aoa3.content.item.weapon.sniper.BaseSniper;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.smartbrainlib.util.RandomUtil;

public class HeadHunter
extends BaseSniper {
    public HeadHunter(float dmg, int durability, int firingDelayTicks, float recoil) {
        super(dmg, durability, firingDelayTicks, recoil);
    }

    @Override
    @Nullable
    public SoundEvent getFiringSound() {
        return (SoundEvent)AoASounds.ITEM_GUN_SNIPER_MEDIUM_FIRE_LONG.get();
    }

    @Override
    protected void doImpactEffect(Entity target, LivingEntity shooter, BaseBullet bullet, Vec3 impactPos, float bulletDmgMultiplier) {
        Level level;
        if (target instanceof LivingEntity && (level = target.f_19853_) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (impactPos != null) {
                double headMinRange = target.m_20191_().f_82289_ + (double)target.m_20192_() - (double)(target.m_20206_() * 0.105f);
                double headMaxRange = headMinRange + (double)(target.m_20206_() * 0.225f);
                if (impactPos.f_82480_ > headMinRange && impactPos.f_82480_ < headMaxRange) {
                    for (int i = 0; i < 5; ++i) {
                        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123798_, impactPos.f_82479_ + RandomUtil.randomValueBetween((double)-0.5, (double)0.5), impactPos.f_82480_ + RandomUtil.randomValueBetween((double)-0.5, (double)0.5), impactPos.f_82481_ + RandomUtil.randomValueBetween((double)-0.5, (double)0.5), 3, 0.0, 0.0, 0.0, 0.0);
                    }
                    serverLevel.m_6263_(null, shooter.m_20185_(), shooter.m_20186_(), shooter.m_20189_(), SoundEvents.f_11871_, SoundSource.PLAYERS, 1.0f, 1.5f);
                    if (shooter.m_21120_(InteractionHand.MAIN_HAND).m_41720_() != this && shooter.m_21120_(InteractionHand.OFF_HAND).m_41720_() != this) {
                        return;
                    }
                    if (shooter instanceof Player) {
                        Player player = (Player)shooter;
                        player.m_36335_().m_41524_((Item)this, (int)((float)this.getFiringDelay() / 2.0f));
                    }
                }
            }
        }
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new Component[0]));
        super.m_7373_(stack, world, tooltip, flag);
    }
}

