/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.shotgun;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.tslat.aoa3.common.registration.item.AoAEnchantments;
import net.tslat.aoa3.content.entity.projectile.gun.BaseBullet;
import net.tslat.aoa3.content.entity.projectile.gun.LimoniteBulletEntity;
import net.tslat.aoa3.content.item.weapon.shotgun.BaseShotgun;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.smartbrainlib.util.RandomUtil;

public class LongShot
extends BaseShotgun {
    public LongShot(float dmg, int pellets, int durability, int fireDelayTicks, float knockbackFactor, float recoil) {
        super(dmg, pellets, durability, fireDelayTicks, knockbackFactor, recoil);
    }

    @Override
    protected boolean fireGun(LivingEntity shooter, ItemStack stack, InteractionHand hand) {
        BaseBullet bullet = this.findAndConsumeAmmo(shooter, stack, hand);
        if (bullet == null) {
            return false;
        }
        int pellets = this.getPelletCount();
        float spreadFactor = 0.1f * (float)pellets * (1.0f - 0.15f * (float)EnchantmentHelper.m_44843_((Enchantment)((Enchantment)AoAEnchantments.FORM.get()), (ItemStack)stack));
        for (int i = 0; i < pellets; ++i) {
            LimoniteBulletEntity pellet = new LimoniteBulletEntity(shooter, this, hand, 6, 1.0f, 0, (float)RandomUtil.randomValueBetween((double)-0.5, (double)0.5) * spreadFactor, (float)RandomUtil.randomValueBetween((double)-0.5, (double)0.5) * spreadFactor, (float)RandomUtil.randomValueBetween((double)-0.5, (double)0.5) * spreadFactor);
            shooter.f_19853_.m_7967_((Entity)pellet);
        }
        if (!shooter.f_19853_.m_5776_()) {
            this.doFiringEffects(shooter, bullet, stack, hand);
        }
        return true;
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new Component[0]));
        super.m_7373_(stack, world, tooltip, flag);
    }
}

