/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.gun;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.content.item.weapon.gun.BaseGun;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.smartbrainlib.util.RandomUtil;

public class LunarAssaultRifle
extends BaseGun {
    private final double baseDmg;
    private final double maxDmg;

    public LunarAssaultRifle(float dmg, int durability, int firingDelayTicks, float recoil) {
        super(dmg, durability, firingDelayTicks, recoil);
        this.baseDmg = (double)dmg - (double)dmg / 2.0;
        this.maxDmg = (double)dmg + (double)dmg / 2.0;
    }

    @Override
    @Nullable
    public SoundEvent getFiringSound() {
        return (SoundEvent)AoASounds.ITEM_GUN_GENERIC_FIRE_3.get();
    }

    @Override
    public float getDamage() {
        return (float)RandomUtil.randomValueBetween((double)this.baseDmg, (double)this.maxDmg);
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, world, tooltip, flag);
        tooltip.set(1, (Component)LocaleUtil.getFormattedItemDescriptionText("items.description.damage.random", LocaleUtil.ItemDescriptionType.ITEM_DAMAGE, new Component[]{LocaleUtil.numToComponent(this.baseDmg), LocaleUtil.numToComponent(this.maxDmg)}));
    }
}

