/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.gun;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.content.entity.projectile.gun.BaseBullet;
import net.tslat.aoa3.content.item.weapon.gun.BaseGun;
import net.tslat.aoa3.scheduling.AoAScheduler;
import net.tslat.aoa3.scheduling.async.EchoGullTask;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.LocaleUtil;

public class EchoGull
extends BaseGun {
    public EchoGull(float dmg, int durability, int firingDelayTicks, float recoil) {
        super(dmg, durability, firingDelayTicks, recoil);
    }

    @Override
    @Nullable
    public SoundEvent getFiringSound() {
        return (SoundEvent)AoASounds.ITEM_GUN_GENERIC_FIRE_5.get();
    }

    @Override
    protected void doImpactEffect(Entity target, LivingEntity shooter, BaseBullet bullet, Vec3 impactPos, float bulletDmgMultiplier) {
        ArrayList<Tuple<LivingEntity, Integer>> entityList = new ArrayList<Tuple<LivingEntity, Integer>>();
        block0: for (LivingEntity entity : bullet.f_19853_.m_6443_(LivingEntity.class, bullet.m_20191_().m_82400_(30.0), EntityUtil.Predicates.HOSTILE_MOB)) {
            int distance = (int)entity.m_20270_((Entity)bullet);
            if (entityList.isEmpty()) {
                entityList.add((Tuple<LivingEntity, Integer>)new Tuple((Object)entity, (Object)distance));
                continue;
            }
            for (int i = 0; i < entityList.size(); ++i) {
                int dist = (Integer)entityList.get(i).m_14419_();
                if (dist != distance && dist <= distance) continue;
                entityList.add(i, (Tuple<LivingEntity, Integer>)new Tuple((Object)entity, (Object)distance));
                continue block0;
            }
        }
        AoAScheduler.scheduleSyncronisedTask(new EchoGullTask(bullet.f_19853_, entityList), 1);
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new Component[0]));
        super.m_7373_(stack, world, tooltip, flag);
    }
}

