/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.gun;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.content.entity.projectile.gun.BaseBullet;
import net.tslat.aoa3.content.entity.projectile.thrown.GrenadeEntity;
import net.tslat.aoa3.content.item.weapon.gun.BaseGun;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.smartbrainlib.util.RandomUtil;

public class Dustometer
extends BaseGun {
    public Dustometer(float dmg, int durability, int firingDelayTicks, float recoil) {
        super(dmg, durability, firingDelayTicks, recoil);
    }

    @Override
    @Nullable
    public SoundEvent getFiringSound() {
        return (SoundEvent)AoASounds.ITEM_GUN_GENERIC_FIRE_2.get();
    }

    @Override
    protected boolean fireGun(LivingEntity shooter, ItemStack stack, InteractionHand hand) {
        if (super.fireGun(shooter, stack, hand)) {
            if (!shooter.f_19853_.m_5776_() && RandomUtil.oneInNChance((int)3)) {
                shooter.f_19853_.m_7967_((Entity)new GrenadeEntity(shooter, this, hand, 120, 0));
                shooter.f_19853_.m_6263_(null, shooter.m_20185_(), shooter.m_20186_(), shooter.m_20189_(), (SoundEvent)AoASounds.ITEM_GUN_AIR_CANNON_FIRE.get(), SoundSource.PLAYERS, 1.0f, this.getFiringSoundPitchAdjust() + (float)RandomUtil.randomScaledGaussianValue((double)0.075f));
            }
            return true;
        }
        return false;
    }

    @Override
    public void doImpactDamage(Entity target, LivingEntity shooter, BaseBullet bullet, Vec3 impactPosition, float bulletDmgMultiplier) {
        if (!(bullet instanceof GrenadeEntity)) {
            super.doImpactDamage(target, shooter, bullet, impactPosition, bulletDmgMultiplier);
        }
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new Component[0]));
        super.m_7373_(stack, world, tooltip, flag);
    }
}

