/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.greatblade;

import com.google.common.collect.ImmutableSetMultimap;
import java.util.UUID;
import net.minecraft.core.Direction;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.util.Lazy;
import net.tslat.aoa3.common.registration.item.AoAEnchantments;
import net.tslat.aoa3.content.capability.volatilestack.VolatileStackCapabilityProvider;
import net.tslat.aoa3.content.item.weapon.sword.BaseSword;

public class BaseGreatblade
extends BaseSword {
    public BaseGreatblade(Tier tier) {
        this(tier, Rarity.COMMON);
    }

    public BaseGreatblade(Tier tier, Rarity rarity) {
        this(tier, -3.24f, rarity);
    }

    public BaseGreatblade(Tier tier, float attackSpeed) {
        this(tier, attackSpeed, Rarity.COMMON);
    }

    public BaseGreatblade(Tier tier, float attackSpeed, Rarity rarity) {
        super(tier, 0, attackSpeed, new Item.Properties().m_41503_(tier.m_6609_()).m_41497_(rarity));
    }

    @Override
    public float getDamageForAttack(LivingEntity target, LivingEntity attacker, ItemStack swordStack, float baseDamage) {
        if (!(!(attacker.f_19789_ > 0.0f) || attacker.m_20096_() || attacker.m_6147_() || attacker.m_20069_() || attacker.m_20159_() || attacker.m_21023_(MobEffects.f_19610_) || !(VolatileStackCapabilityProvider.getOrDefault(swordStack, Direction.NORTH).getValue() >= 1.0f))) {
            baseDamage += 1.15f * (float)EnchantmentHelper.m_44843_((Enchantment)((Enchantment)AoAEnchantments.SEVER.get()), (ItemStack)swordStack);
        }
        return baseDamage;
    }

    @Override
    protected Lazy<ImmutableSetMultimap<Attribute, AttributeModifier>> buildDefaultAttributes() {
        return Lazy.of(() -> ImmutableSetMultimap.of((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)this.m_43299_(), AttributeModifier.Operation.ADDITION), (Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", this.getAttackSpeed(), AttributeModifier.Operation.ADDITION), (Object)((Attribute)ForgeMod.ENTITY_REACH.get()), (Object)new AttributeModifier(UUID.fromString("93bb7485-ce86-4e78-ab50-26f53d78ad9d"), "AoAGreatbladeReach", 1.5, AttributeModifier.Operation.ADDITION)));
    }

    public float m_8102_(ItemStack stack, BlockState state) {
        Material material = state.m_60767_();
        if (material == Material.f_76311_) {
            return 25.0f;
        }
        if (material == Material.f_76300_ || material == Material.f_76302_ || material == Material.f_76274_ || material == Material.f_76285_) {
            return 2.0f;
        }
        return 1.0f;
    }
}

