/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.blaster;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.entity.PartEntity;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.content.capability.volatilestack.VolatileStackCapabilityHandles;
import net.tslat.aoa3.content.capability.volatilestack.VolatileStackCapabilityProvider;
import net.tslat.aoa3.content.entity.projectile.blaster.IroMinerShotEntity;
import net.tslat.aoa3.content.entity.projectile.staff.BaseEnergyShot;
import net.tslat.aoa3.content.item.weapon.blaster.BaseBlaster;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.LocaleUtil;

public class IroMiner
extends BaseBlaster {
    public IroMiner(double dmg, int durability, int fireDelayTicks, float energyCost) {
        super(dmg, durability, fireDelayTicks, energyCost);
    }

    @Override
    @Nullable
    public SoundEvent getFiringSound() {
        return (SoundEvent)AoASounds.ITEM_MOON_SHINER_FIRE.get();
    }

    @Override
    public void fire(ItemStack blaster, LivingEntity shooter) {
        shooter.f_19853_.m_7967_((Entity)new IroMinerShotEntity(shooter, this, 60));
    }

    @Override
    public boolean doEntityImpact(BaseEnergyShot shot, Entity target, LivingEntity shooter) {
        ItemStack heldStack = shooter.m_21205_();
        float damageMod = 1.0f;
        if (heldStack.m_41720_() == this) {
            UUID targetUUID;
            VolatileStackCapabilityHandles cap = VolatileStackCapabilityProvider.getOrDefault(heldStack, null);
            if (target instanceof PartEntity) {
                PartEntity partEntity = (PartEntity)target;
                v0 = partEntity.getParent().m_20148_();
            } else {
                v0 = targetUUID = target.m_20148_();
            }
            if (cap.getObject() != null && targetUUID.equals(cap.getObject())) {
                damageMod = cap.getValue() + 0.02f;
                cap.setValue(damageMod);
            } else {
                cap.setObject(targetUUID);
                cap.setValue(1.0f);
            }
        }
        return DamageUtil.doEnergyProjectileAttack((Entity)shooter, (Entity)shot, target, (float)this.getDamage() * damageMod);
    }

    @Override
    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        stack.m_41784_().m_128405_("HideFlags", ItemStack.TooltipPart.MODIFIERS.m_41809_());
        return new VolatileStackCapabilityProvider();
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new Component[0]));
        super.m_7373_(stack, world, tooltip, flag);
    }
}

