/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.tool.shovel;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.common.packet.AoAPackets;
import net.tslat.aoa3.common.packet.packets.ServerParticlePacket;
import net.tslat.aoa3.common.registration.item.AoATiers;
import net.tslat.aoa3.content.item.LootModifyingItem;
import net.tslat.aoa3.content.item.tool.shovel.BaseShovel;
import net.tslat.aoa3.library.builder.ParticleBuilder;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.smartbrainlib.util.RandomUtil;

public class EmberstoneShovel
extends BaseShovel
implements LootModifyingItem {
    public EmberstoneShovel() {
        super(AoATiers.EMBERSTONE, -4.0f, -3.0f);
    }

    @Override
    public void doLootModification(List<ItemStack> existingLoot, LootContext lootContext) {
        BlockState harvestedBlock = this.getHarvestedBlock(lootContext);
        Block block = harvestedBlock.m_60734_();
        if (block == Blocks.f_50016_ || existingLoot.isEmpty() || this.m_8102_(this.getToolStack(lootContext), harvestedBlock) <= 1.0f) {
            return;
        }
        ServerLevel level = lootContext.m_78952_();
        Vec3 pos = (Vec3)lootContext.m_78953_(LootContextParams.f_81460_);
        for (int i = 0; i < existingLoot.size(); ++i) {
            ItemStack stack = existingLoot.get(i);
            Optional smeltRecipe = level.m_7465_().m_44015_(RecipeType.f_44108_, (Container)new SimpleContainer(new ItemStack[]{stack}), (Level)level);
            if (!smeltRecipe.isPresent()) continue;
            ItemStack smeltedStack = ((SmeltingRecipe)smeltRecipe.get()).m_8043_(level.m_9598_()).m_41777_();
            smeltedStack.m_41764_(smeltedStack.m_41613_() * stack.m_41613_());
            existingLoot.set(i, smeltedStack);
            block.m_49805_(level, BlockPos.m_274446_((Position)pos), (int)((SmeltingRecipe)smeltRecipe.get()).m_43750_());
            ServerParticlePacket particlePacket = new ServerParticlePacket(ParticleBuilder.forPos((ParticleOptions)ParticleTypes.f_123744_, () -> new Vec3(pos.f_82479_ + (double)RandomUtil.randomValueUpTo((float)1.0f), pos.f_82480_ + (double)RandomUtil.randomValueUpTo((float)1.0f), pos.f_82481_ + (double)RandomUtil.randomValueUpTo((float)1.0f))).spawnNTimes(5));
            AoAPackets.messageNearbyPlayers(particlePacket, level, pos.m_82520_(0.5, 0.5, 0.5), 32.0);
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText((Item)this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new Component[0]));
    }
}

