/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.tool.misc;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.tslat.aoa3.content.entity.misc.HaulingFishingBobberEntity;
import net.tslat.aoa3.content.entity.misc.ThermalFishingBobberEntity;
import net.tslat.aoa3.content.item.tool.misc.HaulingRod;
import net.tslat.aoa3.event.custom.AoAEvents;
import net.tslat.aoa3.event.custom.events.HaulingItemFishedEvent;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.smartbrainlib.util.RandomUtil;

public class ThermallyInsulatedRod
extends HaulingRod {
    public ThermallyInsulatedRod(Item.Properties itemProperties) {
        super(itemProperties);
    }

    @Override
    protected void reelIn(ServerPlayer player, HaulingFishingBobberEntity bobber, ItemStack stack, InteractionHand hand) {
        if (bobber.m_20280_((Entity)player) <= 9.0) {
            List<ItemStack> loot = this.landEntity((Player)player, stack, hand, bobber);
            int xp = RandomUtil.randomNumberBetween((int)1, (int)6);
            HaulingItemFishedEvent event = AoAEvents.haulingItemFished(bobber.m_37170_(), stack, loot, xp, 1, bobber);
            if (!event.isCanceled()) {
                this.handleLureRetrieval(player, stack, bobber, loot);
                for (ItemStack lootStack : loot) {
                    ItemEntity entity = new ItemEntity(player.f_19853_, bobber.m_20185_(), bobber.m_20186_(), bobber.m_20189_(), lootStack){

                        public boolean m_6673_(DamageSource source) {
                            return source.m_269533_(DamageTypeTags.f_268745_) || super.m_6673_(source);
                        }
                    };
                    double velX = player.m_20185_() - bobber.m_20185_();
                    double velY = player.m_20186_() - bobber.m_20186_();
                    double velZ = player.m_20189_() - bobber.m_20189_();
                    entity.m_20334_(velX * 0.1, velY * 0.1 + Math.sqrt(Math.sqrt(velX * velX + velY * velY + velZ * velZ)) * 0.1, velZ * 0.1);
                    player.f_19853_.m_7967_((Entity)entity);
                    if (!lootStack.m_204117_(ItemTags.f_13156_)) continue;
                    player.m_36222_(Stats.f_12939_, 1);
                }
            }
            if (!player.m_7500_()) {
                ItemUtil.damageItem(stack, (LivingEntity)player, hand, event.getRodDamage());
            }
            player.f_19853_.m_7967_((Entity)new ExperienceOrb(player.f_19853_, player.m_20185_() + 0.5, player.m_20186_() + 0.5, player.m_20189_() + 0.5, event.getXp()));
            bobber.m_146870_();
        } else {
            Entity hookedEntity = bobber.m_37170_();
            if (hookedEntity != null) {
                float pullStrength = this.getHaulStrengthMod((Player)player, stack, bobber);
                EntityUtil.pullEntityIn((Entity)player, hookedEntity, 0.25f * pullStrength, true);
                hookedEntity.m_20256_(hookedEntity.m_20184_().m_82542_(1.0, 0.5, 1.0));
                if (!player.m_20096_() && bobber.getState() == HaulingFishingBobberEntity.State.HOOKED_IN_ENTITY) {
                    EntityUtil.pullEntityIn(hookedEntity, (Entity)player, 0.25f * pullStrength, true);
                }
            }
        }
    }

    @Override
    protected HaulingFishingBobberEntity getNewBobber(Player player, ItemStack stack, int lureMod, int luckMod) {
        return new ThermalFishingBobberEntity(player, player.f_19853_, stack, luckMod, lureMod);
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> tooltip, TooltipFlag pFlag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText((Item)this, LocaleUtil.ItemDescriptionType.NEUTRAL, 1, new Component[0]));
    }
}

