/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.tool.misc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.common.registration.entity.AoADamageTypes;
import net.tslat.aoa3.content.entity.misc.HaulingFishingBobberEntity;
import net.tslat.aoa3.event.custom.AoAEvents;
import net.tslat.aoa3.event.custom.events.HaulingItemFishedEvent;
import net.tslat.aoa3.event.custom.events.HaulingRodPullEntityEvent;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.smartbrainlib.util.RandomUtil;

public class HaulingRod
extends FishingRodItem {
    public HaulingRod(Item.Properties itemProperties) {
        super(itemProperties);
    }

    public int m_8105_(ItemStack pStack) {
        return 72000;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!level.m_5776_()) {
            if (player.f_36083_ != null && player.f_36083_.f_19853_ == player.f_19853_) {
                if (player.f_36083_ instanceof HaulingFishingBobberEntity) {
                    HaulingFishingBobberEntity bobber = (HaulingFishingBobberEntity)player.f_36083_;
                    if (bobber.getState() == HaulingFishingBobberEntity.State.HOOKED_FISH) {
                        this.reelIn((ServerPlayer)player, bobber, stack, hand);
                        player.m_6672_(hand);
                    } else if (bobber.getState() == HaulingFishingBobberEntity.State.HOOKED_IN_ENTITY) {
                        this.landEntity(player, stack, hand, bobber);
                        player.m_6672_(hand);
                    } else {
                        bobber.m_146870_();
                        player.f_36083_ = null;
                    }
                } else {
                    player.f_36083_.m_146870_();
                    player.f_36083_ = null;
                }
            } else {
                HaulingFishingBobberEntity bobber = this.getNewBobber(player, stack, this.getLureMod(player, stack), this.getLuckMod(player, stack));
                if (bobber != null) {
                    level.m_7967_((Entity)bobber);
                    player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                    this.playCastSound(player, bobber, stack);
                }
            }
        }
        return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.m_5776_());
    }

    protected void reelIn(ServerPlayer player, HaulingFishingBobberEntity bobber, ItemStack stack, InteractionHand hand) {
        if (bobber.m_20280_((Entity)player) <= 9.0) {
            List<ItemStack> loot = this.landEntity((Player)player, stack, hand, bobber);
            int xp = RandomUtil.randomNumberBetween((int)2, (int)10);
            HaulingItemFishedEvent event = AoAEvents.haulingItemFished(bobber.m_37170_(), stack, loot, xp, 1, bobber);
            if (!event.isCanceled()) {
                this.handleLureRetrieval(player, stack, bobber, loot);
                for (ItemStack lootStack : loot) {
                    ItemEntity entity = new ItemEntity(player.f_19853_, bobber.m_20185_(), bobber.m_20186_(), bobber.m_20189_(), lootStack);
                    double velX = player.m_20185_() - bobber.m_20185_();
                    double velY = player.m_20186_() - bobber.m_20186_();
                    double velZ = player.m_20189_() - bobber.m_20189_();
                    Vec3 pullVec = new Vec3(velX, velY + Math.sqrt(Math.sqrt(velX * velX + velY * velY + velZ * velZ)), velZ).m_82490_(0.1);
                    entity.m_20256_(pullVec);
                    player.f_19853_.m_7967_((Entity)entity);
                    if (!player.m_20096_()) {
                        player.m_20256_(pullVec.m_82548_());
                    }
                    if (!lootStack.m_204117_(ItemTags.f_13156_)) continue;
                    player.m_36222_(Stats.f_12939_, 1);
                }
            }
            if (!player.m_7500_()) {
                ItemUtil.damageItem(stack, (LivingEntity)player, hand, event.getRodDamage());
            }
            player.f_19853_.m_7967_((Entity)new ExperienceOrb(player.f_19853_, player.m_20185_() + 0.5, player.m_20186_() + 0.5, player.m_20189_() + 0.5, event.getXp()));
            bobber.m_146870_();
        } else {
            Entity hookedEntity = bobber.m_37170_();
            if (hookedEntity != null) {
                float pullStrength = this.getHaulStrengthMod((Player)player, stack, bobber);
                EntityUtil.pullEntityIn((Entity)player, hookedEntity, 0.25f * pullStrength, true);
                hookedEntity.m_20256_(hookedEntity.m_20184_().m_82542_(1.0, 0.5, 1.0));
                if (!player.m_20096_() && bobber.getState() == HaulingFishingBobberEntity.State.HOOKED_IN_ENTITY) {
                    EntityUtil.pullEntityIn(hookedEntity, (Entity)player, 0.25f * pullStrength, true);
                }
            }
        }
    }

    protected List<ItemStack> landEntity(Player player, ItemStack stack, InteractionHand hand, HaulingFishingBobberEntity bobber) {
        Entity hookedEntity = bobber.m_37170_();
        if (hookedEntity != null && hookedEntity.m_6084_()) {
            float pullStrength = this.getHaulStrengthMod(player, stack, bobber);
            if (bobber.getState() == HaulingFishingBobberEntity.State.HOOKED_IN_ENTITY) {
                HaulingRodPullEntityEvent event = AoAEvents.haulingRodPullEntity(player, stack, bobber, hookedEntity, 0, pullStrength);
                if (event.isCanceled()) {
                    return Collections.emptyList();
                }
                pullStrength = event.getPullStrength();
                if (event.getAdditionalRodDamage() > 0 && !player.m_7500_()) {
                    ItemUtil.damageItem(stack, (LivingEntity)player, hand, event.getAdditionalRodDamage());
                }
            }
            EntityUtil.pullEntityIn((Entity)player, hookedEntity, pullStrength, true);
            hookedEntity.m_20256_(hookedEntity.m_20184_().m_82542_(1.0, 0.25, 1.0));
            if (!player.m_20096_() && bobber.getState() == HaulingFishingBobberEntity.State.HOOKED_IN_ENTITY) {
                EntityUtil.pullEntityIn(hookedEntity, (Entity)player, 0.25f * pullStrength, true);
            }
            player.m_36335_().m_41524_((Item)this, 10);
            return player instanceof ServerPlayer ? this.getLootForHauledEntity((ServerPlayer)player, stack, bobber, hookedEntity) : Collections.emptyList();
        }
        return Collections.emptyList();
    }

    protected List<ItemStack> getLootForHauledEntity(ServerPlayer player, ItemStack stack, HaulingFishingBobberEntity bobber, Entity hookedEntity) {
        if (bobber.getState() == HaulingFishingBobberEntity.State.HOOKED_IN_ENTITY) {
            return Collections.emptyList();
        }
        ArrayList<ItemStack> loot = new ArrayList<ItemStack>();
        if (hookedEntity instanceof ItemEntity) {
            loot.add(((ItemEntity)hookedEntity).m_32055_());
            return loot;
        }
        if (hookedEntity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)hookedEntity;
            DamageSource damageSource = this.killHaulingEntity(bobber, (Player)player, livingEntity);
            LootContext.Builder lootContext = new LootContext.Builder((ServerLevel)player.f_19853_).m_78972_(LootContextParams.f_81460_, (Object)bobber.m_20182_()).m_78972_(LootContextParams.f_81457_, (Object)damageSource).m_78972_(LootContextParams.f_81463_, (Object)stack).m_78972_(LootContextParams.f_81455_, (Object)bobber).m_78972_(LootContextParams.f_81458_, (Object)player).m_78972_(LootContextParams.f_81459_, (Object)bobber).m_78972_(LootContextParams.f_81456_, (Object)player).m_230911_(livingEntity.m_217043_()).m_78963_(bobber.getLuck());
            loot.addAll((Collection<ItemStack>)player.m_20194_().m_129898_().m_79217_(livingEntity.m_5743_()).m_230922_(lootContext.m_78975_(LootContextParamSets.f_81415_)));
            return loot;
        }
        return Collections.emptyList();
    }

    protected void handleLureRetrieval(ServerPlayer player, ItemStack stack, HaulingFishingBobberEntity bobber, Collection<ItemStack> loot) {
        this.playRetrievalSound((Player)player, bobber, stack);
        CriteriaTriggers.f_10553_.m_40416_(player, stack, (FishingHook)bobber, loot);
        player.m_36335_().m_41524_((Item)this, 5);
    }

    protected void playRetrievalSound(Player player, HaulingFishingBobberEntity bobber, ItemStack stack) {
        player.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11939_, SoundSource.NEUTRAL, 1.0f, 0.4f / (float)RandomUtil.randomValueBetween((double)0.8f, (double)1.2f));
    }

    protected void playCastSound(Player player, HaulingFishingBobberEntity bobber, ItemStack stack) {
        player.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11941_, SoundSource.NEUTRAL, 0.5f, 0.4f / (float)RandomUtil.randomValueBetween((double)0.8f, (double)1.2f));
    }

    protected HaulingFishingBobberEntity getNewBobber(Player player, ItemStack stack, int lureMod, int luckMod) {
        return new HaulingFishingBobberEntity(player, player.f_19853_, stack, luckMod, lureMod);
    }

    public float getHaulStrengthMod(Player player, ItemStack stack, HaulingFishingBobberEntity bobber) {
        return 1.0f;
    }

    public int getLureMod(Player player, ItemStack stack) {
        return EnchantmentHelper.m_44916_((ItemStack)stack);
    }

    public int getLuckMod(Player player, ItemStack stack) {
        return EnchantmentHelper.m_44904_((ItemStack)stack);
    }

    private DamageSource killHaulingEntity(FishingHook bobber, Player player, LivingEntity target) {
        DamageSource damageSource = DamageUtil.indirectEntityDamage(AoADamageTypes.HAULING, (Entity)player, (Entity)bobber);
        target.f_19802_ = 0;
        target.m_6469_(damageSource, target.m_21223_() - 0.01f);
        if (target.m_21223_() > 0.01f) {
            target.m_21153_(0.01f);
        }
        target.m_146870_();
        return damageSource;
    }
}

