/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.misc.summoning;

import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.common.packet.AoAPackets;
import net.tslat.aoa3.common.packet.packets.ServerParticlePacket;
import net.tslat.aoa3.common.particletype.CustomisableParticleType;
import net.tslat.aoa3.common.registration.AoAParticleTypes;
import net.tslat.aoa3.common.registration.worldgen.AoADimensions;
import net.tslat.aoa3.content.block.functional.portal.PortalBlock;
import net.tslat.aoa3.content.item.misc.TooltipItem;
import net.tslat.aoa3.content.item.misc.summoning.BossTokenItem;
import net.tslat.aoa3.content.world.teleporter.PortalCoordinatesContainer;
import net.tslat.aoa3.library.builder.ParticleBuilder;
import net.tslat.aoa3.player.ServerPlayerDataManager;
import net.tslat.aoa3.scheduling.AoAScheduler;
import net.tslat.aoa3.util.AdvancementUtil;
import net.tslat.aoa3.util.PlayerUtil;
import net.tslat.aoa3.util.WorldUtil;

public abstract class BossSpawningItem<T extends Entity>
extends TooltipItem
implements BossTokenItem {
    public BossSpawningItem() {
        this(2, new Item.Properties().m_41497_(Rarity.UNCOMMON));
    }

    public BossSpawningItem(int tooltipLines, Item.Properties itemProperties) {
        super(tooltipLines, itemProperties);
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int m_8105_(ItemStack stack) {
        return 60;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (WorldUtil.isWorld(level, AoADimensions.NOWHERE.key)) {
            return InteractionResultHolder.m_19098_((Object)player.m_21120_(hand));
        }
        return ItemUtils.m_150959_((Level)level, (Player)player, (InteractionHand)hand);
    }

    public void m_5929_(Level level, LivingEntity livingEntity, ItemStack stack, int remainingUseDuration) {
        if (!level.m_5776_()) {
            ServerParticlePacket packet = new ServerParticlePacket(3);
            for (int i = 0; i < 3; ++i) {
                packet.particle(ParticleBuilder.forRandomPosInEntity(new CustomisableParticleType.Data((ParticleType<CustomisableParticleType.Data>)((ParticleType)AoAParticleTypes.FLICKERING_SPARKLER.get()), 0.5f, 1.0f, 13742336), (Entity)livingEntity));
            }
            AoAPackets.messageNearbyPlayers(packet, (ServerLevel)level, livingEntity.m_20182_(), 20.0);
        }
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity entity) {
        ServerLevel serverLevel;
        block5: {
            block4: {
                if (WorldUtil.isWorld(level, AoADimensions.NOWHERE.key) || !(level instanceof ServerLevel)) break block4;
                serverLevel = (ServerLevel)level;
                if (entity instanceof ServerPlayer) break block5;
            }
            return stack;
        }
        ServerPlayer pl = (ServerPlayer)entity;
        ServerLevel nowhere = serverLevel.m_7654_().m_129880_(AoADimensions.NOWHERE.key);
        if (nowhere == null) {
            return stack;
        }
        AoAScheduler.scheduleSyncronisedTask(() -> {
            if (AdvancementUtil.isAdvancementCompleted(pl, AdventOfAscension.id("nowhere/root"))) {
                ServerPlayerDataManager plData = PlayerUtil.getAdventPlayer(pl);
                PortalCoordinatesContainer returnLoc = plData.getPortalReturnLocation((ResourceKey<Level>)nowhere.m_46472_());
                pl.changeDimension(nowhere, PortalBlock.getTeleporterForWorld(nowhere));
                pl.f_8906_.m_9774_(17.5, 502.5, 3.5, 0.0f, pl.m_146909_());
                if (returnLoc != null) {
                    plData.setPortalReturnLocation((ResourceKey<Level>)nowhere.m_46472_(), returnLoc);
                }
            } else {
                PlayerUtil.getAdventPlayer(pl).setPortalReturnLocation((ResourceKey<Level>)nowhere.m_46472_(), new PortalCoordinatesContainer((ResourceKey<Level>)level.m_46472_(), pl.m_20185_(), pl.m_20186_(), pl.m_20189_()));
                pl.changeDimension(nowhere, PortalBlock.getTeleporterForWorld(nowhere));
                pl.f_8906_.m_9774_(17.5, 452.5, 3.5, 0.0f, pl.m_146909_());
            }
        }, 1);
        return stack;
    }
}

