/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.misc;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Husk;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.DistExecutor;
import net.tslat.aoa3.client.ClientOperations;
import net.tslat.aoa3.common.registration.entity.AoAMobs;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.common.registration.worldgen.AoADimensions;
import net.tslat.aoa3.content.capability.volatilestack.VolatileStackCapabilityProvider;
import net.tslat.aoa3.content.entity.base.AoATrader;
import net.tslat.aoa3.content.entity.mob.precasia.PrimitiveCarrotopEntity;
import net.tslat.aoa3.content.entity.npc.banker.AoABanker;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.PlayerUtil;
import net.tslat.aoa3.util.WorldUtil;
import net.tslat.smartbrainlib.util.RandomUtil;

public class BlankRealmstone
extends Item {
    public BlankRealmstone() {
        super(new Item.Properties().m_41487_(1));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        if (world.f_46443_) {
            DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> ClientOperations::displayBlankRealmstoneGui);
        }
        return InteractionResultHolder.m_19090_((Object)player.m_21120_(hand));
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        BlockPos pos;
        BlockState state;
        if (!entity.f_19853_.f_46443_ && WorldUtil.isWorld(entity.f_19853_, AoADimensions.PRECASIA.key) && (state = entity.f_19853_.m_8055_(pos = entity.m_20183_())).m_60734_() == Blocks.f_50249_ && ((CropBlock)state.m_60734_()).m_52307_(state)) {
            PrimitiveCarrotopEntity carrotop = new PrimitiveCarrotopEntity((EntityType<? extends PrimitiveCarrotopEntity>)((EntityType)AoAMobs.PRIMITIVE_CARROTOP.get()), entity.f_19853_);
            carrotop.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.2, (double)pos.m_123343_() + 0.5);
            entity.f_19853_.m_7967_((Entity)carrotop);
            entity.m_146870_();
            entity.f_19853_.m_46597_(entity.m_20183_(), Blocks.f_50016_.m_49966_());
        }
        return false;
    }

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        if (WorldUtil.isWorld(player.f_19853_, AoADimensions.CREEPONIA.key) && (target instanceof AoATrader || target instanceof AoABanker)) {
            if (player instanceof ServerPlayer && DamageUtil.isPlayerEnvironmentallyProtected((ServerPlayer)player) && player.m_21120_(hand).m_41720_() == AoAItems.BLANK_REALMSTONE.get()) {
                player.m_21008_(hand, ItemStack.f_41583_);
                ItemUtil.givePlayerItemOrDrop(player, new ItemStack((ItemLike)AoAItems.VOX_PONDS_REALMSTONE.get()));
                PlayerUtil.notifyPlayer(player, (Component)Component.m_237115_((String)("message.dialogue.creeponiaBlankRealmstone." + RandomUtil.randomNumberUpTo((int)3))));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!attacker.f_19853_.f_46443_ && target.m_21223_() <= 0.0f && target instanceof Husk && attacker instanceof Player) {
            attacker.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)AoAItems.BARATHOS_REALMSTONE.get()));
        }
        return super.m_7579_(stack, target, attacker);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new VolatileStackCapabilityProvider();
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.NEUTRAL, 1, new Component[0]));
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.NEUTRAL, 2, new Component[0]));
    }
}

