/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.armour;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.tslat.aoa3.content.item.armour.AdventArmour;
import net.tslat.aoa3.player.ServerPlayerDataManager;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.LocaleUtil;

public class SpeedArmour
extends AdventArmour {
    private static final AttributeModifier SET_BONUS = new AttributeModifier(UUID.fromString("748347d0-6ed4-4917-9495-0e7137fcf61a"), "AoASpeedArmourBoots", 0.1, AttributeModifier.Operation.MULTIPLY_TOTAL);
    private static final AttributeModifier BOOTS_BONUS = new AttributeModifier(UUID.fromString("d0a8b22e-8c0e-42a0-be57-284110170f8c"), "AoASpeedArmourBoots", 0.1, AttributeModifier.Operation.MULTIPLY_TOTAL);
    private static final AttributeModifier LEGS_BONUS = new AttributeModifier(UUID.fromString("31c9600f-b10f-48f0-8acb-2a3009fb3466"), "AoASpeedArmourLegs", 0.1, AttributeModifier.Operation.MULTIPLY_TOTAL);
    private static final AttributeModifier CHESTPLATE_BONUS = new AttributeModifier(UUID.fromString("0f20e0f4-a909-409d-99cf-65fd80f516c7"), "AoASpeedArmourBody", 0.1, AttributeModifier.Operation.MULTIPLY_TOTAL);
    private static final AttributeModifier HELMET_BONUS = new AttributeModifier(UUID.fromString("6d13cd91-39d8-4e68-8c25-b9b45bb729d9"), "AoASpeedArmourHelmet", 0.1, AttributeModifier.Operation.MULTIPLY_TOTAL);

    public SpeedArmour(ArmorItem.Type slot) {
        super(ItemUtil.customArmourMaterial("aoa3:speed", 63, new int[]{4, 9, 9, 3}, 10, SoundEvents.f_11675_, 7.0f), slot);
    }

    @Override
    public AdventArmour.Type setType() {
        return AdventArmour.Type.SPEED;
    }

    @Override
    public void onEquip(ServerPlayerDataManager plData, @Nullable EquipmentSlot slot) {
        if (slot == null) {
            EntityUtil.applyAttributeModifierSafely((LivingEntity)plData.player(), Attributes.f_22279_, SET_BONUS, false);
        } else {
            switch (slot) {
                case FEET: {
                    EntityUtil.applyAttributeModifierSafely((LivingEntity)plData.player(), Attributes.f_22279_, BOOTS_BONUS, false);
                    break;
                }
                case LEGS: {
                    EntityUtil.applyAttributeModifierSafely((LivingEntity)plData.player(), Attributes.f_22279_, LEGS_BONUS, false);
                    break;
                }
                case CHEST: {
                    EntityUtil.applyAttributeModifierSafely((LivingEntity)plData.player(), Attributes.f_22279_, CHESTPLATE_BONUS, false);
                    break;
                }
                case HEAD: {
                    EntityUtil.applyAttributeModifierSafely((LivingEntity)plData.player(), Attributes.f_22279_, HELMET_BONUS, false);
                    break;
                }
            }
        }
    }

    @Override
    public void onUnequip(ServerPlayerDataManager plData, @Nullable EquipmentSlot slot) {
        if (slot == null) {
            EntityUtil.removeAttributeModifier((LivingEntity)plData.player(), Attributes.f_22279_, SET_BONUS);
        } else {
            switch (slot) {
                case FEET: {
                    EntityUtil.removeAttributeModifier((LivingEntity)plData.player(), Attributes.f_22279_, BOOTS_BONUS);
                    break;
                }
                case LEGS: {
                    EntityUtil.removeAttributeModifier((LivingEntity)plData.player(), Attributes.f_22279_, LEGS_BONUS);
                    break;
                }
                case CHEST: {
                    EntityUtil.removeAttributeModifier((LivingEntity)plData.player(), Attributes.f_22279_, CHESTPLATE_BONUS);
                    break;
                }
                case HEAD: {
                    EntityUtil.removeAttributeModifier((LivingEntity)plData.player(), Attributes.f_22279_, HELMET_BONUS);
                    break;
                }
            }
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)this.pieceEffectHeader());
        tooltip.add((Component)LocaleUtil.getFormattedItemDescriptionText("item.aoa3.speed_armour.desc.1", LocaleUtil.ItemDescriptionType.BENEFICIAL, new Component[0]));
        tooltip.add((Component)this.setEffectHeader());
        tooltip.add((Component)LocaleUtil.getFormattedItemDescriptionText("item.aoa3.speed_armour.desc.1", LocaleUtil.ItemDescriptionType.BENEFICIAL, new Component[0]));
    }
}

