/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.armour;

import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.content.item.armour.AdventArmour;
import net.tslat.aoa3.player.ServerPlayerDataManager;
import net.tslat.aoa3.util.AdvancementUtil;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.smartbrainlib.util.RandomUtil;

public class RockboneArmour
extends AdventArmour {
    public RockboneArmour(ArmorItem.Type slot) {
        super(ItemUtil.customArmourMaterial("aoa3:rockbone", 45, new int[]{3, 7, 9, 3}, 10, SoundEvents.f_11675_, 3.0f), slot);
    }

    @Override
    public AdventArmour.Type setType() {
        return AdventArmour.Type.ROCKBONE;
    }

    @Override
    public void onPreAttackReceived(ServerPlayerDataManager plData, @Nullable HashSet<EquipmentSlot> slots, LivingAttackEvent event) {
        if (slots == null && RandomUtil.oneInNChance((int)10) && DamageUtil.isRangedDamage(event.getSource(), (Entity)plData.player(), event.getAmount())) {
            event.setCanceled(true);
            for (ItemStack armour : plData.player().m_6168_()) {
                if (armour.getEnchantmentLevel(Enchantments.f_44969_) >= 4) continue;
                return;
            }
            plData.player().m_8960_().m_135988_(AdvancementUtil.getAdvancement(AdventOfAscension.id("completionist/reverse_stormtrooper")), "max_dodge");
        }
    }

    @Override
    public void onAttackReceived(ServerPlayerDataManager plData, @Nullable HashSet<EquipmentSlot> slots, LivingHurtEvent event) {
        if (slots != null && DamageUtil.isRangedDamage(event.getSource(), (Entity)plData.player(), event.getAmount())) {
            event.setAmount(event.getAmount() * (1.0f - 0.1f * (float)slots.size()));
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)this.pieceEffectHeader());
        tooltip.add((Component)LocaleUtil.getFormattedItemDescriptionText("item.aoa3.rockbone_armour.desc.1", LocaleUtil.ItemDescriptionType.BENEFICIAL, new Component[0]));
        tooltip.add((Component)this.setEffectHeader());
        tooltip.add((Component)LocaleUtil.getFormattedItemDescriptionText("item.aoa3.rockbone_armour.desc.2", LocaleUtil.ItemDescriptionType.BENEFICIAL, new Component[0]));
    }
}

